/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.reflectionmodel;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.resolution.Context;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedInterfaceDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.logic.ConflictingGenericTypesException;
import com.github.javaparser.resolution.logic.InferenceContext;
import com.github.javaparser.resolution.logic.MethodResolutionCapability;
import com.github.javaparser.resolution.model.LambdaArgumentTypePlaceholder;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.typesystem.NullType;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.core.resolution.MethodUsageResolutionCapability;
import com.github.javaparser.symbolsolver.core.resolution.SymbolResolutionCapability;
import com.github.javaparser.symbolsolver.logic.AbstractTypeDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassAdapter;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionFieldDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionMethodResolutionLogic;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ReflectionInterfaceDeclaration
extends AbstractTypeDeclaration
implements ResolvedInterfaceDeclaration,
MethodResolutionCapability,
MethodUsageResolutionCapability,
SymbolResolutionCapability {
    private Class<?> clazz;
    private TypeSolver typeSolver;
    private ReflectionClassAdapter reflectionClassAdapter;

    public ReflectionInterfaceDeclaration(Class<?> clazz, TypeSolver typeSolver) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException();
        }
        this.clazz = clazz;
        this.typeSolver = typeSolver;
        this.reflectionClassAdapter = new ReflectionClassAdapter(clazz, typeSolver, this);
    }

    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        return this.isAssignableBy((ResolvedType)new ReferenceTypeImpl(other));
    }

    public String getPackageName() {
        if (this.clazz.getPackage() != null) {
            return this.clazz.getPackage().getName();
        }
        return null;
    }

    public String getClassName() {
        String canonicalName = this.clazz.getCanonicalName();
        if (canonicalName != null && this.getPackageName() != null) {
            return canonicalName.substring(this.getPackageName().length() + 1);
        }
        return null;
    }

    public String getQualifiedName() {
        return this.clazz.getCanonicalName();
    }

    @Deprecated
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> parameterTypes, boolean staticOnly) {
        return ReflectionMethodResolutionLogic.solveMethod(name, parameterTypes, staticOnly, this.typeSolver, this, this.clazz);
    }

    public String toString() {
        return "ReflectionInterfaceDeclaration{clazz=" + this.clazz.getCanonicalName() + '}';
    }

    public ResolvedType getUsage(Node node) {
        return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReflectionInterfaceDeclaration)) {
            return false;
        }
        ReflectionInterfaceDeclaration that = (ReflectionInterfaceDeclaration)o;
        if (!this.clazz.getCanonicalName().equals(that.clazz.getCanonicalName())) {
            return false;
        }
        return this.getTypeParameters().equals(that.getTypeParameters());
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    @Override
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> parameterTypes, Context invokationContext, List<ResolvedType> typeParameterValues) {
        Optional<MethodUsage> res = ReflectionMethodResolutionLogic.solveMethodAsUsage(name, parameterTypes, this.typeSolver, invokationContext, typeParameterValues, this, this.clazz);
        if (!res.isPresent()) {
            return res;
        }
        return this.performTypeInference(res.get(), parameterTypes);
    }

    private Optional<MethodUsage> performTypeInference(MethodUsage methodUsage, List<ResolvedType> parameterTypes) {
        try {
            InferenceContext inferenceContext = new InferenceContext(this.typeSolver);
            List<ResolvedType> constraintPairs = this.collectTypeConstraints(methodUsage, parameterTypes, inferenceContext);
            return this.resolveInferredTypes(methodUsage, constraintPairs, inferenceContext);
        }
        catch (ConflictingGenericTypesException e) {
            return Optional.empty();
        }
    }

    private List<ResolvedType> collectTypeConstraints(MethodUsage methodUsage, List<ResolvedType> parameterTypes, InferenceContext inferenceContext) {
        boolean isVarArgs = methodUsage.getDeclaration().hasVariadicParameter();
        int formalParamCount = methodUsage.getNoParams();
        int actualParamCount = parameterTypes.size();
        this.validateParameterCount(isVarArgs, formalParamCount, actualParamCount);
        if (isVarArgs) {
            return this.collectVarArgsConstraints(methodUsage, parameterTypes, inferenceContext, formalParamCount);
        }
        return this.collectRegularConstraints(methodUsage, parameterTypes, inferenceContext);
    }

    private void validateParameterCount(boolean isVarArgs, int formalParamCount, int actualParamCount) {
        if (isVarArgs && actualParamCount < formalParamCount - 1) {
            throw new IllegalArgumentException("Too few parameters for varargs method");
        }
        if (!isVarArgs && actualParamCount != formalParamCount) {
            throw new IllegalArgumentException("Parameter count mismatch for non-varargs method");
        }
    }

    private List<ResolvedType> collectRegularConstraints(MethodUsage methodUsage, List<ResolvedType> parameterTypes, InferenceContext inferenceContext) {
        LinkedList<ResolvedType> constraints = new LinkedList<ResolvedType>();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            ResolvedType formalType = methodUsage.getParamType(i);
            ResolvedType actualType = parameterTypes.get(i);
            constraints.add(inferenceContext.addPair(formalType, actualType));
        }
        return constraints;
    }

    private List<ResolvedType> collectVarArgsConstraints(MethodUsage methodUsage, List<ResolvedType> parameterTypes, InferenceContext inferenceContext, int formalParamCount) {
        LinkedList<ResolvedType> constraints = new LinkedList<ResolvedType>();
        int regularParamCount = formalParamCount - 1;
        for (int i = 0; i < regularParamCount; ++i) {
            ResolvedType formalType = methodUsage.getParamType(i);
            ResolvedType actualType = parameterTypes.get(i);
            constraints.add(inferenceContext.addPair(formalType, actualType));
        }
        if (formalParamCount > 0) {
            ResolvedType varargsParamType = methodUsage.getParamType(regularParamCount);
            this.processVarArgsParameter(varargsParamType, parameterTypes, regularParamCount, inferenceContext, constraints);
        }
        return constraints;
    }

    private void processVarArgsParameter(ResolvedType varargsParamType, List<ResolvedType> parameterTypes, int regularParamCount, InferenceContext inferenceContext, List<ResolvedType> constraints) {
        if (!varargsParamType.isArray()) {
            throw new IllegalStateException("Varargs parameter is not an array type");
        }
        ResolvedType componentType = varargsParamType.asArrayType().getComponentType();
        int actualParamCount = parameterTypes.size();
        if (this.isDirectArrayPassing(parameterTypes, regularParamCount, actualParamCount)) {
            ResolvedType actualArrayType = parameterTypes.get(regularParamCount);
            constraints.add(inferenceContext.addPair(varargsParamType, actualArrayType));
        } else {
            for (int i = regularParamCount; i < actualParamCount; ++i) {
                ResolvedType actualType = parameterTypes.get(i);
                constraints.add(inferenceContext.addPair(componentType, actualType));
            }
        }
    }

    private boolean isDirectArrayPassing(List<ResolvedType> parameterTypes, int regularParamCount, int actualParamCount) {
        return actualParamCount == regularParamCount + 1 && parameterTypes.get(regularParamCount).isArray();
    }

    private Optional<MethodUsage> resolveInferredTypes(MethodUsage methodUsage, List<ResolvedType> constraints, InferenceContext inferenceContext) {
        ResolvedType returnType = inferenceContext.addSingle(methodUsage.returnType());
        for (int i = 0; i < constraints.size() && i < methodUsage.getNoParams(); ++i) {
            ResolvedType resolvedParamType = inferenceContext.resolve(constraints.get(i));
            methodUsage = methodUsage.replaceParamType(i, resolvedParamType);
        }
        methodUsage = methodUsage.replaceReturnType(inferenceContext.resolve(returnType));
        return Optional.of(methodUsage);
    }

    public boolean canBeAssignedTo(ResolvedReferenceTypeDeclaration other) {
        if (other instanceof LambdaArgumentTypePlaceholder) {
            return this.isFunctionalInterface();
        }
        if (other.getQualifiedName().equals(this.getQualifiedName())) {
            return true;
        }
        if (this.clazz.getSuperclass() != null && new ReflectionInterfaceDeclaration(this.clazz.getSuperclass(), this.typeSolver).canBeAssignedTo(other)) {
            return true;
        }
        for (Class<?> interfaze : this.clazz.getInterfaces()) {
            if (!new ReflectionInterfaceDeclaration(interfaze, this.typeSolver).canBeAssignedTo(other)) continue;
            return true;
        }
        return other.isJavaLangObject();
    }

    public boolean isAssignableBy(ResolvedType type) {
        ReferenceTypeImpl otherTypeDeclaration;
        if (type instanceof NullType) {
            return true;
        }
        if (type instanceof LambdaArgumentTypePlaceholder) {
            return this.isFunctionalInterface();
        }
        if (type.isArray()) {
            return false;
        }
        if (type.isPrimitive()) {
            return false;
        }
        if (type.describe().equals(this.getQualifiedName())) {
            return true;
        }
        if (type instanceof ReferenceTypeImpl && (otherTypeDeclaration = (ReferenceTypeImpl)type).getTypeDeclaration().isPresent()) {
            return ((ResolvedReferenceTypeDeclaration)otherTypeDeclaration.getTypeDeclaration().get()).canBeAssignedTo((ResolvedReferenceTypeDeclaration)this);
        }
        return false;
    }

    public boolean isTypeParameter() {
        return false;
    }

    public ResolvedFieldDeclaration getField(String name) {
        return this.reflectionClassAdapter.getField(name);
    }

    public List<ResolvedFieldDeclaration> getAllFields() {
        return this.reflectionClassAdapter.getAllFields();
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        for (Field field : this.clazz.getFields()) {
            if (!field.getName().equals(name)) continue;
            return SymbolReference.solved((ResolvedDeclaration)new ReflectionFieldDeclaration(field, typeSolver));
        }
        return SymbolReference.unsolved();
    }

    public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
        return this.reflectionClassAdapter.getAncestors();
    }

    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return this.reflectionClassAdapter.getDeclaredMethods();
    }

    public boolean hasField(String name) {
        return this.reflectionClassAdapter.hasField(name);
    }

    public String getName() {
        return this.clazz.getSimpleName();
    }

    public boolean isInterface() {
        return true;
    }

    public List<ResolvedReferenceType> getInterfacesExtended() {
        ArrayList<ResolvedReferenceType> res = new ArrayList<ResolvedReferenceType>();
        for (Class<?> i : this.clazz.getInterfaces()) {
            res.add((ResolvedReferenceType)new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)new ReflectionInterfaceDeclaration(i, this.typeSolver)));
        }
        return res;
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        return this.reflectionClassAdapter.containerType();
    }

    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        return Arrays.stream(this.clazz.getDeclaredClasses()).map(ic -> ReflectionFactory.typeDeclarationFor(ic, this.typeSolver)).collect(Collectors.toSet());
    }

    public ResolvedInterfaceDeclaration asInterface() {
        return this;
    }

    public boolean hasDirectlyAnnotation(String canonicalName) {
        return this.reflectionClassAdapter.hasDirectlyAnnotation(canonicalName);
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return this.reflectionClassAdapter.getTypeParameters();
    }

    public AccessSpecifier accessSpecifier() {
        return ReflectionFactory.modifiersToAccessLevel(this.clazz.getModifiers());
    }

    public List<ResolvedConstructorDeclaration> getConstructors() {
        return Collections.emptyList();
    }
}

