/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.DnsResolver;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.naming.NameNotFoundException;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;

public class DnsJavaResolver
implements DnsResolver {
    private final SimpleResolver resolver;

    public DnsJavaResolver() {
        this.resolver = null;
    }

    public DnsJavaResolver(String dnsServer, int port) {
        try {
            this.resolver = new SimpleResolver(dnsServer);
            this.resolver.setPort(port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown DNS server host: " + dnsServer, e);
        }
    }

    @Override
    public Collection<String> resolveTxt(String domainName) throws NameNotFoundException {
        try {
            Lookup lookup = new Lookup(domainName, 16);
            if (this.resolver != null) {
                lookup.setResolver((Resolver)this.resolver);
            }
            lookup.run();
            int resultCode = lookup.getResult();
            if (resultCode == 3) {
                throw new NameNotFoundException("DNS record not found for " + domainName);
            }
            if (resultCode == 4) {
                throw new NameNotFoundException("DNS record type TXT not found for " + domainName);
            }
            if (resultCode != 0) {
                throw new RuntimeException("DNS lookup failed for " + domainName + ": " + lookup.getErrorString());
            }
            Record[] records = lookup.getAnswers();
            if (records == null || records.length == 0) {
                throw new NameNotFoundException("DNS record type TXT not found for " + domainName);
            }
            return Arrays.stream(records).map(r -> (TXTRecord)r).flatMap(txtRecord -> txtRecord.getStrings().stream()).sorted().collect(Collectors.toList());
        }
        catch (TextParseException e) {
            throw new RuntimeException("Invalid domain name format: " + domainName, e);
        }
    }
}

