/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.ProtocolHandler;
import com.google.cloud.sql.core.mdx.MetadataExchange;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

class MdxSocket
extends SSLSocket {
    private final ProtocolHandler protocolHandler;
    private final SSLSocket delegate;
    private final MdxInputStream in;
    private final MdxOutputStream out;
    private final AtomicBoolean firstWriteAttempted = new AtomicBoolean(false);
    private final AtomicBoolean firstReadAttempted = new AtomicBoolean(false);
    private final AtomicReference<MetadataExchange.MetadataExchangeResponse> response = new AtomicReference();
    private final MetadataExchange.MetadataExchangeRequest.ClientProtocolType clientProtocolType;

    MdxSocket(ProtocolHandler protocolHandler, SSLSocket delegate, MetadataExchange.MetadataExchangeRequest.ClientProtocolType clientProtocolType) throws IOException {
        this.protocolHandler = protocolHandler;
        this.delegate = delegate;
        this.in = new MdxInputStream(new BufferedInputStream(delegate.getInputStream()));
        this.out = new MdxOutputStream(delegate.getOutputStream());
        this.clientProtocolType = clientProtocolType;
    }

    MetadataExchange.MetadataExchangeResponse getMdxResponse() {
        return this.response.get();
    }

    void sendMdxIfFirstWrite() throws IOException {
        if (this.firstWriteAttempted.compareAndSet(false, true)) {
            this.protocolHandler.sendMdx(this.out, this.clientProtocolType);
        }
    }

    void readMdxIfFirstRead() throws IOException {
        if (this.firstReadAttempted.compareAndSet(false, true)) {
            MetadataExchange.MetadataExchangeResponse res = this.protocolHandler.readMdxResponse(this.in);
            this.response.set(res);
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.delegate.connect(endpoint);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.delegate.connect(endpoint, timeout);
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.delegate.bind(bindpoint);
    }

    @Override
    public InetAddress getInetAddress() {
        return this.delegate.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.delegate.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.delegate.getLocalSocketAddress();
    }

    @Override
    public SocketChannel getChannel() {
        return this.delegate.getChannel();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.delegate.setTcpNoDelay(on);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.delegate.getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.delegate.setSoLinger(on, linger);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.delegate.getSoLinger();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.delegate.sendUrgentData(data);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.delegate.setOOBInline(on);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.delegate.getOOBInline();
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.delegate.setSoTimeout(timeout);
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.delegate.getSoTimeout();
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.delegate.setSendBufferSize(size);
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        return this.delegate.getSendBufferSize();
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.delegate.setReceiveBufferSize(size);
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.delegate.getReceiveBufferSize();
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.delegate.setKeepAlive(on);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.delegate.getKeepAlive();
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.delegate.setTrafficClass(tc);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.delegate.getTrafficClass();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.delegate.setReuseAddress(on);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.delegate.getReuseAddress();
    }

    @Override
    public synchronized void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        this.delegate.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.delegate.shutdownOutput();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean isConnected() {
        return this.delegate.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.delegate.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.delegate.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.delegate.isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.delegate.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.delegate.getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] strings) {
        this.delegate.setEnabledCipherSuites(strings);
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.delegate.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.delegate.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] strings) {
        this.delegate.setEnabledProtocols(strings);
    }

    @Override
    public SSLSession getSession() {
        return this.delegate.getSession();
    }

    @Override
    public SSLSession getHandshakeSession() {
        return this.delegate.getHandshakeSession();
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.delegate.addHandshakeCompletedListener(handshakeCompletedListener);
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.delegate.removeHandshakeCompletedListener(handshakeCompletedListener);
    }

    @Override
    public void startHandshake() throws IOException {
        this.delegate.startHandshake();
    }

    @Override
    public void setUseClientMode(boolean b) {
        this.delegate.setUseClientMode(b);
    }

    @Override
    public boolean getUseClientMode() {
        return this.delegate.getUseClientMode();
    }

    @Override
    public void setNeedClientAuth(boolean b) {
        this.delegate.setNeedClientAuth(b);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.delegate.getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean b) {
        this.delegate.setWantClientAuth(b);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.delegate.getWantClientAuth();
    }

    @Override
    public void setEnableSessionCreation(boolean b) {
        this.delegate.setEnableSessionCreation(b);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.delegate.getEnableSessionCreation();
    }

    @Override
    public SSLParameters getSSLParameters() {
        return this.delegate.getSSLParameters();
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        this.delegate.setSSLParameters(params);
    }

    class MdxInputStream
    extends InputStream {
        private final InputStream delegate;

        MdxInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public int read() throws IOException {
            MdxSocket.this.readMdxIfFirstRead();
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            MdxSocket.this.readMdxIfFirstRead();
            return this.delegate.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            MdxSocket.this.readMdxIfFirstRead();
            return this.delegate.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }

    class MdxOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        MdxOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int b) throws IOException {
            MdxSocket.this.sendMdxIfFirstWrite();
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            MdxSocket.this.sendMdxIfFirstWrite();
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            MdxSocket.this.sendMdxIfFirstWrite();
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

