/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ImpersonatedCredentials;
import com.google.cloud.sql.CredentialFactory;
import java.util.Arrays;
import java.util.List;

class ServiceAccountImpersonatingCredentialFactory
implements CredentialFactory {
    private final CredentialFactory source;
    private final List<String> delegates;
    private final String targetPrincipal;

    ServiceAccountImpersonatingCredentialFactory(CredentialFactory source, String targetPrincipal, List<String> delegates) {
        if (targetPrincipal == null || targetPrincipal.isEmpty()) {
            throw new IllegalArgumentException("targetPrincipal must not be empty");
        }
        this.source = source;
        this.delegates = delegates;
        this.targetPrincipal = targetPrincipal;
    }

    @Override
    public HttpRequestInitializer create() {
        GoogleCredentials credentials = this.getCredentials();
        return new HttpCredentialsAdapter((Credentials)credentials);
    }

    @Override
    public GoogleCredentials getCredentials() {
        GoogleCredentials credentials = this.source.getCredentials();
        credentials = ImpersonatedCredentials.newBuilder().setSourceCredentials(credentials).setTargetPrincipal(this.targetPrincipal).setDelegates(this.delegates).setScopes(Arrays.asList("https://www.googleapis.com/auth/sqlservice.admin", "https://www.googleapis.com/auth/cloud-platform")).build();
        return credentials;
    }
}

