/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.grpc.bridge.runtime.servlet;

import dev.resteasy.grpc.bridge.runtime.servlet.MockServletOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class AsyncMockServletOutputStream
extends MockServletOutputStream {
    private static final ByteArrayOutputStream CLOSE_MARKER = new ByteArrayOutputStream();
    private STATE state = STATE.OPEN;
    private volatile ArrayList<ByteArrayOutputStream> list = new ArrayList();

    @Override
    public boolean isClosed() {
        return this.state == STATE.CLOSED;
    }

    public synchronized ByteArrayOutputStream await() throws InterruptedException {
        if (this.state == STATE.CLOSED) {
            return null;
        }
        if (this.state == STATE.CLOSING) {
            ByteArrayOutputStream baos = this.list.remove(0);
            if (CLOSE_MARKER == baos) {
                this.state = STATE.CLOSED;
                return null;
            }
            return baos;
        }
        while (true) {
            if (this.list.size() > 0) {
                ByteArrayOutputStream baos = this.list.remove(0);
                if (CLOSE_MARKER == baos) {
                    this.state = STATE.CLOSED;
                    return null;
                }
                return baos;
            }
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public synchronized void release() throws IOException {
        if (this.state != STATE.OPEN) {
            return;
        }
        this.list.add(this.getDelegate());
        ((Object)((Object)this)).notify();
    }

    public synchronized void release(ByteArrayOutputStream baos) throws IOException {
        if (this.state != STATE.OPEN) {
            return;
        }
        this.list.add(baos);
        ((Object)((Object)this)).notify();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.state != STATE.OPEN) {
            return;
        }
        this.state = this.list.isEmpty() ? STATE.CLOSED : STATE.CLOSING;
        this.list.add(CLOSE_MARKER);
        ((Object)((Object)this)).notifyAll();
    }

    private static enum STATE {
        OPEN,
        CLOSING,
        CLOSED;

    }
}

