/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.grpc.bridge.runtime.sse;

import dev.resteasy.grpc.bridge.runtime.servlet.AsyncMockServletOutputStream;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.sse.OutboundSseEvent;
import jakarta.ws.rs.sse.SseEventSink;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CompletionStage;

public class SseEventOutputImpl
extends GenericType<OutboundSseEvent>
implements SseEventSink {
    private boolean closed;
    private final MessageBodyWriter<Object> writer;
    private final AsyncMockServletOutputStream amsos;

    public SseEventOutputImpl(MessageBodyWriter<?> writer, AsyncMockServletOutputStream amsos) {
        this.writer = writer;
        this.amsos = amsos;
    }

    public void close() {
        this.closed = true;
        try {
            this.amsos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public CompletionStage<?> send(OutboundSseEvent event) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writer.writeTo((Object)event, null, null, null, null, null, (OutputStream)baos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

