/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.grpc.Internal;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@Internal
public final class BackendMetricPropagation {
    public final boolean propagateCpuUtilization;
    public final boolean propagateMemUtilization;
    public final boolean propagateApplicationUtilization;
    private final boolean propagateAllNamedMetrics;
    private final ImmutableSet<String> namedMetricKeys;

    private BackendMetricPropagation(boolean propagateCpuUtilization, boolean propagateMemUtilization, boolean propagateApplicationUtilization, boolean propagateAllNamedMetrics, ImmutableSet<String> namedMetricKeys) {
        this.propagateCpuUtilization = propagateCpuUtilization;
        this.propagateMemUtilization = propagateMemUtilization;
        this.propagateApplicationUtilization = propagateApplicationUtilization;
        this.propagateAllNamedMetrics = propagateAllNamedMetrics;
        this.namedMetricKeys = (ImmutableSet)Preconditions.checkNotNull(namedMetricKeys, (Object)"namedMetricKeys");
    }

    public static BackendMetricPropagation fromMetricSpecs(@Nullable List<String> metricSpecs) {
        if (metricSpecs == null || metricSpecs.isEmpty()) {
            return new BackendMetricPropagation(false, false, false, false, (ImmutableSet<String>)ImmutableSet.of());
        }
        boolean propagateCpuUtilization = false;
        boolean propagateMemUtilization = false;
        boolean propagateApplicationUtilization = false;
        boolean propagateAllNamedMetrics = false;
        ImmutableSet.Builder namedMetricKeysBuilder = ImmutableSet.builder();
        block12: for (String spec : metricSpecs) {
            String metricKey;
            if (spec == null) continue;
            switch (spec) {
                case "cpu_utilization": {
                    propagateCpuUtilization = true;
                    continue block12;
                }
                case "mem_utilization": {
                    propagateMemUtilization = true;
                    continue block12;
                }
                case "application_utilization": {
                    propagateApplicationUtilization = true;
                    continue block12;
                }
                case "named_metrics.*": {
                    propagateAllNamedMetrics = true;
                    continue block12;
                }
            }
            if (!spec.startsWith("named_metrics.") || (metricKey = spec.substring("named_metrics.".length())).isEmpty()) continue;
            namedMetricKeysBuilder.add((Object)metricKey);
        }
        return new BackendMetricPropagation(propagateCpuUtilization, propagateMemUtilization, propagateApplicationUtilization, propagateAllNamedMetrics, (ImmutableSet<String>)namedMetricKeysBuilder.build());
    }

    public boolean shouldPropagateNamedMetric(String metricKey) {
        return this.propagateAllNamedMetrics || this.namedMetricKeys.contains((Object)metricKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackendMetricPropagation that = (BackendMetricPropagation)o;
        return this.propagateCpuUtilization == that.propagateCpuUtilization && this.propagateMemUtilization == that.propagateMemUtilization && this.propagateApplicationUtilization == that.propagateApplicationUtilization && this.propagateAllNamedMetrics == that.propagateAllNamedMetrics && Objects.equals(this.namedMetricKeys, that.namedMetricKeys);
    }

    public int hashCode() {
        return Objects.hash(this.propagateCpuUtilization, this.propagateMemUtilization, this.propagateApplicationUtilization, this.propagateAllNamedMetrics, this.namedMetricKeys);
    }
}

