/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security.certprovider;

import com.google.common.base.Preconditions;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.client.Bootstrapper;
import io.grpc.xds.internal.security.certprovider.CertProviderSslContextProvider;
import io.grpc.xds.internal.security.certprovider.CertificateProviderStore;
import io.grpc.xds.internal.security.trust.XdsTrustManagerFactory;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.net.ssl.X509TrustManager;

final class CertProviderServerSslContextProvider
extends CertProviderSslContextProvider {
    CertProviderServerSslContextProvider(Node node, @Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders, CommonTlsContext.CertificateProviderInstance certInstance, CommonTlsContext.CertificateProviderInstance rootCertInstance, CertificateValidationContext staticCertValidationContext, EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext, CertificateProviderStore certificateProviderStore) {
        super(node, certProviders, (CommonTlsContext.CertificateProviderInstance)Preconditions.checkNotNull((Object)certInstance, (Object)"Server SSL requires certInstance"), rootCertInstance, staticCertValidationContext, downstreamTlsContext, certificateProviderStore);
    }

    @Override
    protected final AbstractMap.SimpleImmutableEntry<SslContextBuilder, X509TrustManager> getSslContextBuilderAndTrustManager(CertificateValidationContext certificateValidationContextdationContext) throws CertStoreException, CertificateException, IOException {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((PrivateKey)this.savedKey, (Iterable)this.savedCertChain);
        XdsTrustManagerFactory trustManagerFactory = null;
        if (this.isMtls() && this.savedSpiffeTrustMap != null) {
            trustManagerFactory = new XdsTrustManagerFactory(this.savedSpiffeTrustMap, certificateValidationContextdationContext, false);
        } else if (this.isMtls()) {
            trustManagerFactory = new XdsTrustManagerFactory(this.savedTrustedRoots.toArray(new X509Certificate[0]), certificateValidationContextdationContext, false);
        }
        this.setClientAuthValues(sslContextBuilder, trustManagerFactory);
        sslContextBuilder = GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder);
        return new AbstractMap.SimpleImmutableEntry<SslContextBuilder, Object>(sslContextBuilder, null);
    }
}

