/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security.certprovider;

import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.client.Bootstrapper;
import io.grpc.xds.internal.security.CommonTlsContextUtil;
import io.grpc.xds.internal.security.DynamicSslContextProvider;
import io.grpc.xds.internal.security.certprovider.CertificateProvider;
import io.grpc.xds.internal.security.certprovider.CertificateProviderStore;
import io.grpc.xds.internal.security.certprovider.IgnoreUpdatesWatcher;
import io.grpc.xds.internal.security.certprovider.SystemRootCertificateProvider;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.io.Closeable;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

abstract class CertProviderSslContextProvider
extends DynamicSslContextProvider
implements CertificateProvider.Watcher {
    @Nullable
    private final NoExceptionCloseable certHandle;
    @Nullable
    private final NoExceptionCloseable rootCertHandle;
    @Nullable
    private final CommonTlsContext.CertificateProviderInstance certInstance;
    @Nullable
    protected final CommonTlsContext.CertificateProviderInstance rootCertInstance;
    @Nullable
    protected PrivateKey savedKey;
    @Nullable
    protected List<X509Certificate> savedCertChain;
    @Nullable
    protected List<X509Certificate> savedTrustedRoots;
    @Nullable
    protected Map<String, List<X509Certificate>> savedSpiffeTrustMap;
    private final boolean isUsingSystemRootCerts;

    protected CertProviderSslContextProvider(Node node, @Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders, CommonTlsContext.CertificateProviderInstance certInstance, CommonTlsContext.CertificateProviderInstance rootCertInstance, CertificateValidationContext staticCertValidationContext, EnvoyServerProtoData.BaseTlsContext tlsContext, CertificateProviderStore certificateProviderStore) {
        super(tlsContext, staticCertValidationContext);
        Bootstrapper.CertificateProviderInfo certProviderInstanceConfig;
        boolean sharedCertInstance;
        this.certInstance = certInstance;
        this.rootCertInstance = rootCertInstance;
        this.isUsingSystemRootCerts = rootCertInstance == null && CommonTlsContextUtil.isUsingSystemRootCerts(tlsContext.getCommonTlsContext());
        boolean createCertInstance = certInstance != null && certInstance.isInitialized();
        boolean createRootCertInstance = rootCertInstance != null && rootCertInstance.isInitialized();
        boolean bl = sharedCertInstance = createCertInstance && createRootCertInstance && rootCertInstance.getInstanceName().equals(certInstance.getInstanceName());
        if (createCertInstance) {
            certProviderInstanceConfig = CertProviderSslContextProvider.getCertProviderConfig(certProviders, certInstance.getInstanceName());
            CertificateProvider.Watcher watcher = this;
            if (!sharedCertInstance && !this.isUsingSystemRootCerts) {
                watcher = new IgnoreUpdatesWatcher(watcher, true);
            }
            this.certHandle = certProviderInstanceConfig == null ? null : certificateProviderStore.createOrGetProvider(certInstance.getCertificateName(), certProviderInstanceConfig.pluginName(), certProviderInstanceConfig.config(), watcher, true)::close;
        } else {
            this.certHandle = null;
        }
        if (createRootCertInstance && !sharedCertInstance) {
            certProviderInstanceConfig = CertProviderSslContextProvider.getCertProviderConfig(certProviders, rootCertInstance.getInstanceName());
            this.rootCertHandle = certProviderInstanceConfig == null ? null : certificateProviderStore.createOrGetProvider(rootCertInstance.getCertificateName(), certProviderInstanceConfig.pluginName(), certProviderInstanceConfig.config(), new IgnoreUpdatesWatcher(this, false), false)::close;
        } else if (rootCertInstance == null && CommonTlsContextUtil.isUsingSystemRootCerts(tlsContext.getCommonTlsContext())) {
            SystemRootCertificateProvider systemRootProvider = new SystemRootCertificateProvider(this);
            systemRootProvider.start();
            this.rootCertHandle = systemRootProvider::close;
        } else {
            this.rootCertHandle = null;
        }
    }

    private static Bootstrapper.CertificateProviderInfo getCertProviderConfig(@Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders, String pluginInstanceName) {
        return certProviders != null ? certProviders.get(pluginInstanceName) : null;
    }

    @Nullable
    protected static CommonTlsContext.CertificateProviderInstance getCertProviderInstance(CommonTlsContext commonTlsContext) {
        if (commonTlsContext.hasTlsCertificateProviderInstance()) {
            return CommonTlsContextUtil.convert(commonTlsContext.getTlsCertificateProviderInstance());
        }
        CommonTlsContext.CertificateProviderInstance deprecatedInstance = commonTlsContext.hasTlsCertificateCertificateProviderInstance() ? commonTlsContext.getTlsCertificateCertificateProviderInstance() : null;
        return deprecatedInstance;
    }

    @Nullable
    protected static CertificateValidationContext getStaticValidationContext(CommonTlsContext commonTlsContext) {
        CommonTlsContext.CombinedCertificateValidationContext combinedValidationContext;
        if (commonTlsContext.hasValidationContext()) {
            return commonTlsContext.getValidationContext();
        }
        if (commonTlsContext.hasCombinedValidationContext() && (combinedValidationContext = commonTlsContext.getCombinedValidationContext()).hasDefaultValidationContext()) {
            return combinedValidationContext.getDefaultValidationContext();
        }
        return null;
    }

    @Nullable
    protected static CommonTlsContext.CertificateProviderInstance getRootCertProviderInstance(CommonTlsContext commonTlsContext) {
        CertificateValidationContext certValidationContext = CertProviderSslContextProvider.getStaticValidationContext(commonTlsContext);
        if (certValidationContext != null && certValidationContext.hasCaCertificateProviderInstance()) {
            return CommonTlsContextUtil.convert(certValidationContext.getCaCertificateProviderInstance());
        }
        return null;
    }

    @Override
    public final void updateCertificate(PrivateKey key, List<X509Certificate> certChain) {
        this.savedKey = key;
        this.savedCertChain = certChain;
        this.updateSslContextWhenReady();
    }

    @Override
    public final void updateTrustedRoots(List<X509Certificate> trustedRoots) {
        this.savedTrustedRoots = trustedRoots;
        this.updateSslContextWhenReady();
    }

    @Override
    public final void updateSpiffeTrustMap(Map<String, List<X509Certificate>> spiffeTrustMap) {
        this.savedSpiffeTrustMap = spiffeTrustMap;
        this.updateSslContextWhenReady();
    }

    private void updateSslContextWhenReady() {
        if (this.isMtls()) {
            if (this.savedKey != null && (this.savedTrustedRoots != null || this.savedSpiffeTrustMap != null)) {
                this.updateSslContext();
                this.clearKeysAndCerts();
            }
        } else if (this.isRegularTlsAndClientSide()) {
            if (this.savedTrustedRoots != null || this.savedSpiffeTrustMap != null) {
                this.updateSslContext();
                this.clearKeysAndCerts();
            }
        } else if (this.isRegularTlsAndServerSide() && this.savedKey != null) {
            this.updateSslContext();
            this.clearKeysAndCerts();
        }
    }

    private void clearKeysAndCerts() {
        this.savedKey = null;
        if (!this.isUsingSystemRootCerts) {
            this.savedTrustedRoots = null;
            this.savedSpiffeTrustMap = null;
        }
        this.savedCertChain = null;
    }

    protected final boolean isMtls() {
        return this.certInstance != null && (this.rootCertInstance != null || this.isUsingSystemRootCerts);
    }

    protected final boolean isRegularTlsAndClientSide() {
        return (this.rootCertInstance != null || this.isUsingSystemRootCerts) && this.certInstance == null;
    }

    protected final boolean isRegularTlsAndServerSide() {
        return this.certInstance != null && this.rootCertInstance == null;
    }

    @Override
    protected final CertificateValidationContext generateCertificateValidationContext() {
        return this.staticCertificateValidationContext;
    }

    @Override
    public final void close() {
        if (this.certHandle != null) {
            this.certHandle.close();
        }
        if (this.rootCertHandle != null) {
            this.rootCertHandle.close();
        }
    }

    static interface NoExceptionCloseable
    extends Closeable {
        @Override
        public void close();
    }
}

