/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security.certprovider;

import io.grpc.Status;
import io.grpc.xds.internal.security.certprovider.CertificateProvider;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

final class SystemRootCertificateProvider
extends CertificateProvider {
    public SystemRootCertificateProvider(CertificateProvider.Watcher watcher) {
        super(new CertificateProvider.DistributorWatcher(), false);
        this.getWatcher().addWatcher(watcher);
    }

    @Override
    public void start() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            List<TrustManager> trustManagers = Arrays.asList(trustManagerFactory.getTrustManagers());
            List<X509Certificate> rootCerts = trustManagers.stream().filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).map(trustManager -> Arrays.asList(trustManager.getAcceptedIssuers())).flatMap(Collection::stream).collect(Collectors.toList());
            this.getWatcher().updateTrustedRoots(rootCerts);
        }
        catch (KeyStoreException | NoSuchAlgorithmException ex) {
            this.getWatcher().onError(Status.UNAVAILABLE.withDescription("Could not load system root certs").withCause((Throwable)ex));
        }
    }

    @Override
    public void close() {
        for (CertificateProvider.Watcher watcher : this.getWatcher().getDownstreamWatchers()) {
            this.getWatcher().removeWatcher(watcher);
        }
    }
}

