/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security.trust;

import io.grpc.internal.GrpcUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public final class CertificateUtils {
    public static boolean isXdsSniEnabled = GrpcUtil.getFlag((String)"GRPC_EXPERIMENTAL_XDS_SNI", (boolean)true);
    public static boolean useChannelAuthorityIfNoSniApplicable = GrpcUtil.getFlag((String)"GRPC_USE_CHANNEL_AUTHORITY_IF_NO_SNI_APPLICABLE", (boolean)false);

    static X509Certificate[] toX509Certificates(File file) throws CertificateException, IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            X509Certificate[] x509CertificateArray;
            try (BufferedInputStream bis = new BufferedInputStream(fis);){
                x509CertificateArray = CertificateUtils.toX509Certificates(bis);
            }
            return x509CertificateArray;
        }
    }

    public static X509Certificate[] toX509Certificates(InputStream inputStream) throws CertificateException, IOException {
        return io.grpc.util.CertificateUtils.getX509Certificates((InputStream)inputStream);
    }

    public static PrivateKey getPrivateKey(InputStream inputStream) throws Exception {
        return io.grpc.util.CertificateUtils.getPrivateKey((InputStream)inputStream);
    }

    private CertificateUtils() {
    }
}

