/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.misc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.agama.model.EngineConfig;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;

@ApplicationScoped
public class FlowUtils {
    private static final Path SALT_PATH = Paths.get("/etc/jans/conf/salt", new String[0]);
    private static final HmacAlgorithms HASH_ALG = HmacAlgorithms.HMAC_SHA_512;
    @Inject
    private Logger logger;
    @Inject
    private ObjectMapper mapper;
    @Inject
    private EngineConfig engineConfig;

    public boolean serviceEnabled() {
        return this.engineConfig.isEnabled();
    }

    public String toJsonString(Map<String, String[]> map) throws JsonProcessingException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (map != null) {
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String[] list = map.get(key = iterator.next());
                result.put(key, list.length == 1 ? list[0] : Arrays.asList(list));
            }
        }
        return this.mapper.writeValueAsString(result);
    }

    public void printScopeIds(Scriptable scope) {
        List scopeIds = Stream.of(scope.getIds()).map(Object::toString).collect(Collectors.toList());
        this.logger.trace("Global scope has {} ids: {}", (Object)scopeIds.size(), scopeIds);
    }

    public String hash(String message) throws IOException {
        return new HmacUtils(HASH_ALG, this.sharedKey()).hmacHex(message);
    }

    public String hash(byte[] message) throws IOException {
        return new HmacUtils(HASH_ALG, this.sharedKey()).hmacHex(message);
    }

    private String sharedKey() throws IOException {
        Properties p = new Properties();
        p.load(new StringReader(Files.readString(SALT_PATH, StandardCharsets.UTF_8)));
        return p.getProperty("encodeSalt");
    }
}

