/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.script;

import io.jans.agama.model.EngineConfig;
import io.jans.service.cdi.util.CdiUtil;
import io.jans.util.Pair;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LogUtils.class);
    private static final String PLACEHOLDER = "%";
    private static final String PREFIX_FORMAT = "|%s| ";
    private static int maxIterableItems = 1;

    public static void log(Object ... rest) {
        LogUtils.logPrefixed(null, rest);
    }

    public static void logPrefixed(String prefix, Object ... rest) {
        Object sfirst;
        LogLevel level;
        int dummyArgs = 0;
        int nargs = rest.length - 1;
        maxIterableItems = ((EngineConfig)CdiUtil.bean(EngineConfig.class)).getMaxItemsLoggedInCollections();
        Object first = rest[0];
        if (first != null && first instanceof String) {
            Pair<LogLevel, String> p = LogUtils.getLogLevel(first.toString());
            level = (LogLevel)((Object)p.getFirst());
            if (LogUtils.ignoreLogStatement(level)) {
                return;
            }
            Pair<String, Integer> q = LogUtils.getFormatString((String)p.getSecond(), nargs);
            sfirst = (String)q.getFirst();
            dummyArgs = (Integer)q.getSecond();
        } else {
            level = LogLevel.INFO;
            if (LogUtils.ignoreLogStatement(level)) {
                return;
            }
            sfirst = LogUtils.asString(first) + (String)LogUtils.getFormatString("", nargs).getFirst();
        }
        Object[] args = new String[nargs + dummyArgs];
        for (int i = 0; i < nargs; ++i) {
            args[i] = LogUtils.asString(rest[i + 1]);
        }
        Arrays.fill(args, nargs, args.length, "");
        String pref = prefix == null ? "" : String.format(PREFIX_FORMAT, prefix);
        String result = pref + String.format((String)sfirst, args);
        switch (level) {
            case ERROR: {
                LOG.error(result);
                break;
            }
            case WARN: {
                LOG.warn(result);
                break;
            }
            case INFO: {
                LOG.info(result);
                break;
            }
            case DEBUG: {
                LOG.debug(result);
                break;
            }
            case TRACE: {
                LOG.trace(result);
            }
        }
    }

    private static boolean ignoreLogStatement(LogLevel logLevel) {
        switch (logLevel) {
            case TRACE: {
                return !LOG.isTraceEnabled();
            }
            case DEBUG: {
                return !LOG.isDebugEnabled();
            }
            case INFO: {
                return !LOG.isInfoEnabled();
            }
            case WARN: {
                return !LOG.isWarnEnabled();
            }
            case ERROR: {
                return !LOG.isErrorEnabled();
            }
        }
        return false;
    }

    private static Pair<LogLevel, String> getLogLevel(String first) {
        LogLevel level = null;
        String newFirst = null;
        String suffix = " ";
        if (first.startsWith("@") && (level = (LogLevel)Stream.of(LogLevel.values()).filter(l -> {
            String lev = l.getValue();
            return first.startsWith("@" + lev.substring(0, 1) + suffix) || first.startsWith("@" + lev + suffix);
        }).findFirst().orElse(null)) != null) {
            int levLen = first.substring(2).startsWith(suffix) ? 1 : level.getValue().length();
            newFirst = first.substring(1 + levLen + suffix.length());
        }
        if (level == null) {
            newFirst = first;
            level = LogLevel.INFO;
        }
        return new Pair((Object)level, (Object)newFirst);
    }

    private static Pair<String, Integer> getFormatString(String str, int nargs) {
        Integer dummyArgs = 0;
        Object tmp = str.replace(PLACEHOLDER, "%s");
        int existingPlaceHolders = ((String)tmp).length() - str.length();
        if (existingPlaceHolders > 0) {
            int excess = existingPlaceHolders - nargs;
            if (excess < 0) {
                tmp = (String)tmp + " %s".repeat(-excess);
            } else {
                dummyArgs = excess;
            }
        } else {
            tmp = str + " %s".repeat(nargs);
        }
        return new Pair(tmp, (Object)dummyArgs);
    }

    private static String subListAsString(List<?> list, int originalSize) {
        StringBuilder sb = new StringBuilder("[");
        list.forEach(item -> sb.append(LogUtils.asString(item)).append(", "));
        if (originalSize > maxIterableItems) {
            sb.append("...").append(originalSize - maxIterableItems).append(" more");
        } else {
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.append("]").toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String asString(Object obj) {
        if (obj == null) {
            return "null";
        }
        Class<?> objCls = obj.getClass();
        if (objCls.equals(Double.class)) {
            Double d = (Double)obj;
            if (Math.floor(d) == d && d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
                return Long.toString(d.longValue());
            }
        } else {
            if (objCls.isArray()) {
                ArrayList<Object> list = new ArrayList<Object>();
                int len = Array.getLength(obj);
                for (int i = 0; i < Math.min(len, maxIterableItems); ++i) {
                    list.add(Array.get(obj, i));
                }
                return LogUtils.subListAsString(list, len);
            }
            if (Collection.class.isInstance(obj)) {
                Collection col = (Collection)obj;
                Iterator iterator = col.iterator();
                ArrayList list = new ArrayList();
                int len = col.size();
                for (int i = 0; i < Math.min(len, maxIterableItems); ++i) {
                    list.add(iterator.next());
                }
                return LogUtils.subListAsString(list, len);
            }
            if (Map.class.isInstance(obj)) {
                Map map = (Map)obj;
                ArrayList entries = new ArrayList();
                int i = 0;
                for (Object key : map.keySet()) {
                    entries.add(new AbstractMap.SimpleImmutableEntry(key, map.get(key)));
                    if (++i != maxIterableItems) continue;
                    break;
                }
                return LogUtils.subListAsString(entries, map.size());
            }
            if (Map.Entry.class.isInstance(obj)) {
                Map.Entry e = (Map.Entry)obj;
                return String.format("(%s: %s)", LogUtils.asString(e.getKey()), LogUtils.asString(e.getValue()));
            }
            if (Throwable.class.isInstance(obj)) {
                Throwable t = (Throwable)obj;
                try (StringWriter sw = new StringWriter();){
                    PrintWriter pw = new PrintWriter(sw);
                    try {
                        t.printStackTrace(pw);
                        String string = sw.toString();
                        pw.close();
                        return string;
                    }
                    catch (Throwable throwable) {
                        try {
                            pw.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return obj.toString();
    }

    private static enum LogLevel {
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;


        String getValue() {
            return this.toString().toLowerCase();
        }
    }
}

