/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.service;

import io.jans.util.Pair;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Inject;
import jakarta.inject.Qualifier;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.proxy.WeldClientProxy;
import org.slf4j.Logger;

@ApplicationScoped
public class ManagedBeanService {
    @Inject
    private Logger logger;
    @Inject
    private BeanManager beanManager;

    public static <T> T instance(Class<T> subtype, Set<Annotation> qualifiers) {
        return (T)CDI.current().select(subtype, qualifiers.toArray(new Annotation[0])).get();
    }

    public Pair<Class<?>, Set<Annotation>> getBeanMetadata(Object obj) {
        Set<Annotation> qualifiers;
        Class beanClass;
        block3: {
            beanClass = null;
            qualifiers = null;
            try {
                WeldClientProxy proxy = (WeldClientProxy)WeldClientProxy.class.cast(obj);
                Bean bean = proxy.getMetadata().getBean();
                beanClass = bean.getBeanClass();
                qualifiers = new HashSet<Annotation>(bean.getQualifiers());
            }
            catch (ClassCastException e) {
                if (!obj.getClass().isAnnotationPresent(Singleton.class)) break block3;
                beanClass = obj.getClass();
                qualifiers = this.getClassQualifiers(beanClass);
            }
        }
        if (beanClass != null) {
            qualifiers.remove(new AnnotationLiteral<Any>(){});
            this.logger.debug("Qualifiers found in class {}: {}", (Object)beanClass.getSimpleName(), qualifiers);
        }
        return new Pair((Object)beanClass, qualifiers);
    }

    private Set<Annotation> getClassQualifiers(Class<?> cls) {
        HashSet<Annotation> qualies = new HashSet<Annotation>();
        for (Annotation ann : cls.getAnnotations()) {
            Retention ret;
            Class<? extends Annotation> clazz = ann.annotationType();
            if (!clazz.isAnnotationPresent(Qualifier.class) || (ret = clazz.getAnnotation(Retention.class)) == null || !ret.value().equals((Object)RetentionPolicy.RUNTIME)) continue;
            qualies.add(ann);
        }
        return qualies;
    }
}

