/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.agama.model.EngineConfig;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.service.cdi.event.ConfigurationUpdate;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class ServicesFactory {
    @Inject
    private Logger logger;
    private ObjectMapper mapper;
    private EngineConfig econfig;

    @Produces
    public ObjectMapper mapperInstance() {
        return this.mapper;
    }

    @Produces
    @ApplicationScoped
    public EngineConfig engineConfigInstance() {
        return this.econfig;
    }

    public void updateConfiguration(@Observes @ConfigurationUpdate AppConfiguration appConfiguration) {
        try {
            EngineConfig newConfig = appConfiguration.getAgamaConfiguration();
            if (newConfig == null) {
                this.logger.info("Agama will not be available in this deployment");
            } else {
                this.logger.info("Refreshing Agama configuration...");
                BeanUtils.copyProperties((Object)this.econfig, (Object)newConfig);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @PostConstruct
    public void init() {
        this.mapper = new ObjectMapper();
        this.econfig = new EngineConfig();
    }
}

