/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.timer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.agama.dsl.TranspilationResult;
import io.jans.agama.dsl.Transpiler;
import io.jans.agama.dsl.TranspilerException;
import io.jans.agama.dsl.error.SyntaxException;
import io.jans.agama.engine.misc.FlowUtils;
import io.jans.agama.model.Flow;
import io.jans.agama.model.FlowMetadata;
import io.jans.agama.model.ProtoFlow;
import io.jans.agama.timer.TranspilationEvent;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;

@ApplicationScoped
public class Transpilation {
    private static final int DELAY = 10 + (int)(10.0 * Math.random());
    private static final int INTERVAL = 30;
    private static final double PR = 0.25;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    private Logger logger;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private ObjectMapper mapper;
    @Inject
    private FlowUtils futils;
    private AtomicBoolean isActive;
    private Map<String, Integer> traces;

    public void initTimer() {
        this.logger.info("Initializing Agama transpilation Timer");
        this.isActive = new AtomicBoolean(false);
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(DELAY, 30), (Object)new TranspilationEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void run(@Observes @Scheduled TranspilationEvent event) {
        if (!this.futils.serviceEnabled()) {
            return;
        }
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.process();
            this.logger.debug("Transpilation timer has run.");
        }
        catch (Exception e) {
            this.logger.error("An error occurred while running transpilation timer", (Throwable)e);
        }
        finally {
            this.isActive.set(false);
        }
    }

    public void process() throws IOException {
        ProtoFlow pfl;
        List flows = this.entryManager.findEntries("ou=flows,ou=agama,o=jans", ProtoFlow.class, null);
        Map map = flows.stream().collect(Collectors.toMap(ProtoFlow::getQname, Function.identity()));
        if (this.traces == null) {
            this.traces = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ProtoFlow)e.getValue()).getRevision()));
            this.traces = new HashMap<String, Integer>(this.traces);
        } else {
            this.traces.keySet().retainAll(map.keySet());
        }
        ArrayList<String> candidates = new ArrayList<String>();
        for (String name : map.keySet()) {
            pfl = (ProtoFlow)map.get(name);
            Integer rev = pfl.getRevision();
            if (rev == null) continue;
            if (!this.traces.containsKey(name)) {
                candidates.add(name);
                this.traces.put(name, rev);
                continue;
            }
            if (!(pfl.getTransHash() == null && Math.random() < 0.25 || rev < 0) && rev <= this.traces.get(name)) continue;
            candidates.add(name);
        }
        int s = candidates.size();
        if (s > 0) {
            String shortError;
            Object error;
            Flow fl;
            block13: {
                String qname = (String)candidates.get((int)((double)s * Math.random()));
                this.logger.info("Starting transpilation of flow '{}'", (Object)qname);
                pfl = (ProtoFlow)map.get(qname);
                pfl.setTransHash(null);
                if (pfl.getRevision() < 0) {
                    pfl.setRevision(0);
                }
                this.logger.debug("Marking the script is under compilation");
                this.entryManager.merge((Object)pfl);
                this.traces.put(qname, pfl.getRevision());
                fl = (Flow)this.entryManager.findEntries("ou=flows,ou=agama,o=jans", Flow.class, Filter.createEqualityFilter((String)"agFlowQname", (Object)qname), null, 1).get(0);
                error = null;
                shortError = null;
                try {
                    TranspilationResult result = Transpiler.transpile((String)qname, (String)fl.getSource());
                    this.logger.debug("Successful transpilation");
                    FlowMetadata meta = fl.getMetadata();
                    meta.setFuncName(result.getFuncName());
                    meta.setInputs(result.getInputs());
                    meta.setTimeout(result.getTimeout());
                    String compiled = result.getCode();
                    fl.setMetadata(meta);
                    fl.setTranspiled(compiled);
                    fl.setTransHash(this.futils.hash(compiled));
                    fl.setCodeError(null);
                    this.logger.debug("Persisting changes...");
                    this.entryManager.merge((Object)fl);
                }
                catch (SyntaxException se) {
                    try {
                        error = this.mapper.writeValueAsString((Object)se);
                        shortError = se.getMessage();
                    }
                    catch (JsonProcessingException je) {
                        error = je.getMessage();
                    }
                }
                catch (TranspilerException te) {
                    error = te.getMessage();
                    if (te.getCause() == null) break block13;
                    error = (String)error + "\n" + te.getCause().getMessage();
                }
            }
            if (error != null) {
                this.logger.error("Transpilation failed!");
                if (shortError != null) {
                    this.logger.error(shortError);
                }
                fl.setCodeError((String)error);
                this.logger.debug("Persisting error details...");
                this.entryManager.merge((Object)fl);
                this.logger.warn("Check database for errors");
            }
        }
    }
}

