/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama;

import io.jans.agama.engine.model.FlowResult;
import io.jans.agama.engine.model.FlowStatus;
import io.jans.agama.engine.script.LogUtils;
import io.jans.agama.engine.service.AgamaPersistenceService;
import io.jans.agama.engine.service.FlowService;
import io.jans.agama.engine.service.WebContext;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import org.slf4j.Logger;

@RequestScoped
public class NativeJansFlowBridge {
    @Inject
    private Logger logger;
    @Inject
    private AgamaPersistenceService aps;
    @Inject
    private FlowService fs;
    @Inject
    private WebContext webContext;

    public String getTriggerUrl() {
        return this.webContext.getContextPath() + "/fl/agama.fls";
    }

    public Boolean prepareFlow(String sessionId, String qname, String jsonInput, boolean nativeClient, String startUrl) throws Exception {
        this.logger.info("Preparing flow '{}'", (Object)qname);
        Boolean alreadyRunning = null;
        if (this.aps.flowEnabled(qname)) {
            FlowStatus st = this.aps.getFlowStatus(sessionId);
            alreadyRunning = st != null;
            if (alreadyRunning.booleanValue() && !qname.equals(st.getQname())) {
                this.logger.warn("Flow {} seems to be already running. Will be terminated", (Object)st.getQname());
                this.fs.terminateFlow();
                st = null;
            }
            if (st == null) {
                int timeout = this.aps.getEffectiveFlowTimeout(qname, nativeClient);
                if (timeout <= 0) {
                    throw new Exception("Flow timeout negative or zero. Check your AS configuration or flow definition");
                }
                long expireAt = System.currentTimeMillis() + 1000L * (long)timeout;
                st = new FlowStatus();
                st.setStartedAt(0L);
                st.setQname(qname);
                st.setJsonInput(jsonInput);
                st.setFinishBefore(expireAt);
                st.setNativeClient(nativeClient);
                st.setStartUrl(startUrl);
                this.aps.createFlowRun(sessionId, st, expireAt);
                LogUtils.log("@w Effective timeout for this flow will be % seconds", timeout);
            }
        }
        return alreadyRunning;
    }

    public FlowResult close() throws IOException {
        FlowStatus st = this.fs.getRunningFlowStatus();
        if (st == null) {
            this.logger.error("No current flow running");
        } else if (st.getStartedAt() != -1L) {
            this.logger.error("Current flow hasn't finished");
        } else {
            this.fs.terminateFlow();
            return st.getResult();
        }
        return null;
    }
}

