/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.service;

import groovy.lang.GroovyClassLoader;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import io.jans.agama.engine.service.MethodInvoker;
import io.jans.agama.model.EngineConfig;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.slf4j.Logger;

@ApplicationScoped
public class ActionService {
    private static final List<String> CLASS_EXTENSIONS = Arrays.asList("java", "groovy");
    @Inject
    private Logger logger;
    @Inject
    private EngineConfig econf;
    @Inject
    private MethodInvoker invoker;
    private GroovyScriptEngine gse;
    private GroovyClassLoader loader;

    public Object callAction(Object instance, String className, String methodName, Object[] rhinoArgs) throws Exception {
        Class actionCls;
        boolean noInst;
        block12: {
            noInst = instance == null;
            actionCls = null;
            if (!noInst) {
                actionCls = instance.getClass();
                className = actionCls.getName();
            } else {
                try {
                    actionCls = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    ResourceException rex = null;
                    for (String ext : CLASS_EXTENSIONS) {
                        try {
                            String classFilePath = className.replace('.', File.separatorChar) + "." + ext;
                            actionCls = this.gse.loadScriptByName(classFilePath);
                            break;
                        }
                        catch (ResourceException re) {
                            if (rex != null) continue;
                            rex = re;
                        }
                        catch (ScriptException se) {
                            throw se;
                        }
                        catch (Exception ex) {
                            throw new ScriptException((Throwable)ex);
                        }
                    }
                    if (actionCls != null) break block12;
                    throw new ClassNotFoundException(rex.getMessage(), rex);
                }
            }
        }
        this.logger.debug("Class {} loaded successfully", (Object)className);
        if (noInst) {
            if (methodName.equals("new")) {
                return this.invoker.callConstructor(actionCls, rhinoArgs);
            }
            if (methodName.equals("class")) {
                this.logger.debug("Returning class object");
                return actionCls;
            }
        }
        return this.invoker.call(actionCls, instance, methodName, rhinoArgs);
    }

    public GroovyClassLoader getClassLoader() {
        return this.loader;
    }

    public Class<?> classFromName(String qname) throws ClassNotFoundException {
        return Class.forName(qname, false, (ClassLoader)this.loader);
    }

    @PostConstruct
    private void init() {
        URL url = null;
        try {
            url = new URL(String.format("file://%s%s/", this.econf.getRootDir(), this.econf.getScriptsPath()));
        }
        catch (MalformedURLException e) {
            this.logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
        this.logger.debug("Creating a Groovy Script Engine based at {}", (Object)url.toString());
        this.gse = new GroovyScriptEngine(new URL[]{url});
        CompilerConfiguration cc = this.gse.getConfig();
        cc.setDefaultScriptExtension(CLASS_EXTENSIONS.get(0));
        cc.setScriptExtensions(CLASS_EXTENSIONS.stream().collect(Collectors.toSet()));
        this.loader = this.gse.getGroovyClassLoader();
        this.loader.setShouldRecompile(Boolean.valueOf(true));
    }
}

