/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ads.timer;

import io.jans.ads.Deployer;
import io.jans.ads.timer.DeploymentEvent;
import io.jans.agama.engine.misc.FlowUtils;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

@ApplicationScoped
public class DeployerTimer {
    @Inject
    private Deployer deployer;
    @Inject
    private Logger logger;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private FlowUtils futils;
    private AtomicBoolean isActive;
    private static final int DELAY = 5 + (int)(10.0 * Math.random());
    private static final int INTERVAL = 30;

    public void initTimer() {
        this.logger.info("Initializing Agama transpilation Timer");
        this.isActive = new AtomicBoolean(false);
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(DELAY, 30), (Object)new DeploymentEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void run(@Observes @Scheduled DeploymentEvent event) {
        if (!this.futils.serviceEnabled()) {
            return;
        }
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.deployer.process();
            this.logger.debug("ADS deployer timer has run.");
        }
        catch (Exception e) {
            this.logger.error("An error occurred while running ADS deployer timer", (Throwable)e);
        }
        finally {
            this.isActive.set(false);
        }
    }
}

