/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.client;

import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import io.jans.agama.engine.client.WebResponse;
import io.jans.util.Pair;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniBrowser {
    public static final String FLOW_PAUSED_URL_KEY = "_url";
    private static final Logger logger = LoggerFactory.getLogger(MiniBrowser.class);
    private String rootUrl;
    private int connectionTimeout;
    private int readTimeout;
    private int maxErrorContentLength;

    public MiniBrowser(String rootUrl) {
        this(rootUrl, 3500, 5500, 4096);
    }

    public MiniBrowser(String rootUrl, int connectionTimeout, int readTimeout, int maxErrorContentLength) {
        this.rootUrl = rootUrl;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.maxErrorContentLength = maxErrorContentLength;
    }

    public Pair<Outcome, JSONObject> move(String phantomSid, String relativeUrl, String jsonPayload) {
        try {
            return this.moveImpl(phantomSid, relativeUrl, jsonPayload);
        }
        catch (Exception e) {
            String error = e.getMessage();
            logger.error(error, (Throwable)e);
            JSONObject jobj = new JSONObject(Map.of("description", error));
            return new Pair((Object)Outcome.CLIENT_ERROR, (Object)jobj);
        }
    }

    private Pair<Outcome, JSONObject> moveImpl(String phantomSid, String relativeUrl, String jsonPayload) throws Exception {
        JSONObject jobj;
        Object error = null;
        String url = this.normalize(relativeUrl);
        logger.info("Moving forward from {}", (Object)url);
        HTTPResponse response = this.sendRequest(phantomSid, new URL(url), jsonPayload);
        WebResponse wr = WebResponse.from(response);
        int status = wr.getStatus();
        if (Response.Status.Family.familyOf((int)status).equals((Object)Response.Status.Family.REDIRECTION)) {
            String location = response.getHeaderValue("Location");
            if (location != null) {
                wr = null;
                logger.info("Redirecting to {}", (Object)location);
                response = this.sendRequest(phantomSid, new URL(this.normalize(location)), null);
                wr = WebResponse.from(response);
                if ("application/json".equals(wr.getContentType()) && wr.getStatus() == 200) {
                    logger.info("Returning JSON contents");
                    JSONObject jobj2 = new JSONObject(wr.getBody());
                    jobj2.put(FLOW_PAUSED_URL_KEY, (Object)location);
                    return new Pair((Object)Outcome.FLOW_PAUSED, (Object)jobj2);
                }
                error = "Expecting OK JSON response for " + location;
            } else {
                error = "Target of redirection is missing";
            }
        } else if ("application/json".equals(wr.getContentType()) && status == 200) {
            logger.info("Seems to have landed to the finish page");
            jobj = new JSONObject(wr.getBody());
            if (jobj.has("success")) {
                return new Pair((Object)Outcome.FLOW_FINISHED, (Object)jobj);
            }
            error = "Unexpected response to " + url;
        } else {
            error = "Unexpected response to " + url;
        }
        logger.error((String)error);
        jobj = new JSONObject(Map.of("description", error));
        String contentType = wr.getContentType();
        jobj.put("status", wr.getStatus());
        jobj.put("contentType", (Object)Optional.ofNullable(contentType).orElse((String)JSONObject.NULL));
        String body = wr.getBody();
        if (body == null) {
            jobj.put("body", JSONObject.NULL);
        } else if ("application/json".equals(contentType)) {
            jobj.put("body", (Object)new JSONObject(body));
        } else {
            body = body.substring(0, Math.min(body.length(), this.maxErrorContentLength));
            jobj.put("body", (Object)body);
        }
        return new Pair((Object)Outcome.ENGINE_ERROR, (Object)jobj);
    }

    private HTTPResponse sendRequest(String phantomSid, URL url, String jsonPayload) throws IOException {
        boolean noPayload = jsonPayload == null;
        HTTPRequest request = new HTTPRequest(noPayload ? HTTPRequest.Method.GET : HTTPRequest.Method.POST, url);
        request.setConnectTimeout(this.connectionTimeout);
        request.setReadTimeout(this.readTimeout);
        request.setFollowRedirects(false);
        request.setHeader("Content-Type", new String[]{"application/json"});
        request.setHeader("Cookie", new String[]{String.format("session_id=%s;", phantomSid)});
        if (!noPayload) {
            request.setBody(jsonPayload);
        }
        return request.send();
    }

    private String normalize(String relativeUrl) {
        String url = relativeUrl.startsWith(this.rootUrl) ? "" : this.rootUrl;
        return url + relativeUrl;
    }

    public static enum Outcome {
        CLIENT_ERROR,
        ENGINE_ERROR,
        FLOW_FINISHED,
        FLOW_PAUSED;

    }
}

