/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.page;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.agama.engine.service.LabelsService;
import io.jans.agama.engine.service.MessagesService;
import io.jans.agama.engine.service.WebContext;
import io.jans.service.CacheService;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;

@RequestScoped
public class Page {
    private static final String WEB_CTX_KEY = "webCtx";
    private static final String CACHE_KEY = "cache";
    @Inject
    private WebContext webContext;
    @Inject
    private ObjectMapper mapper;
    @Inject
    private MessagesService msgsService;
    @Inject
    private LabelsService labelsService;
    @Inject
    private CacheService cache;
    private String templatePath;
    private Map<String, Object> dataModel;

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public Object getDataModel() {
        return this.dataModel;
    }

    public Object getAugmentedDataModel(boolean includeContextualData, Map<String, Object> extra) {
        HashMap<String, Object> model = new HashMap<String, Object>(this.dataModel);
        if (includeContextualData) {
            model.putIfAbsent(WEB_CTX_KEY, this.webContext);
            model.putIfAbsent("msgs", this.msgsService);
            model.putIfAbsent("labels", this.labelsService);
            model.putIfAbsent(CACHE_KEY, this.cache);
        }
        if (extra != null) {
            extra.forEach((k, v) -> model.putIfAbsent((String)k, v));
        }
        return model;
    }

    public void setDataModel(Object object) {
        this.dataModel = object == null ? Map.of() : this.mapFromObject(object);
    }

    private Map<String, Object> mapFromObject(Object object) {
        return (Map)this.mapper.convertValue(object, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    @PostConstruct
    private void init() {
        this.dataModel = Map.of();
    }
}

