/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.script;

import io.jans.agama.engine.continuation.PendingRedirectException;
import io.jans.agama.engine.continuation.PendingRenderException;
import io.jans.agama.engine.misc.PrimitiveUtils;
import io.jans.agama.engine.script.LogUtils;
import io.jans.agama.engine.service.ActionService;
import io.jans.agama.engine.service.FlowService;
import io.jans.agama.model.EngineConfig;
import io.jans.service.cdi.util.CdiUtil;
import io.jans.util.Pair;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.AccessDeniedException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeContinuation;
import org.mozilla.javascript.NativeJavaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptUtils.class);

    public static Pair<String, String> pauseForRender(String page, boolean allowCallbackResume, Object data) throws PendingRenderException, AccessDeniedException, URISyntaxException {
        page = ScriptUtils.normalize(page);
        Context cx = Context.enter();
        try {
            PendingRenderException pending = new PendingRenderException((NativeContinuation)cx.captureContinuation().getContinuation());
            pending.setTemplatePath(page);
            pending.setDataModel(data);
            pending.setAllowCallbackResume(allowCallbackResume);
            LOG.debug("Pausing flow");
            throw pending;
        }
        catch (Throwable throwable) {
            Context.exit();
            throw throwable;
        }
    }

    public static Pair<Boolean, String> pauseForExternalRedirect(String url) throws PendingRedirectException {
        Context cx = Context.enter();
        try {
            PendingRedirectException pending = new PendingRedirectException((NativeContinuation)cx.captureContinuation().getContinuation());
            pending.setLocation(url);
            pending.setAllowCallbackResume(true);
            LOG.debug("Pausing flow");
            throw pending;
        }
        catch (Throwable throwable) {
            Context.exit();
            throw throwable;
        }
    }

    public static boolean testEquality(Object a, Object b) {
        boolean bnull;
        boolean anull = a == null;
        boolean bl = bnull = b == null;
        if (a == b) {
            return true;
        }
        if (!anull && !bnull) {
            Class<?> bClass;
            Class<?> aClass = a.getClass();
            if (!aClass.equals(bClass = b.getClass())) {
                if (aClass.equals(Double.class) && Number.class.isInstance(b)) {
                    return a.equals(((Number)b).doubleValue());
                }
                if (bClass.equals(Double.class) && Number.class.isInstance(a)) {
                    return b.equals(((Number)a).doubleValue());
                }
                LOG.warn("Trying to compare instances of {} and {}", (Object)aClass.getName(), (Object)bClass.getName());
                LogUtils.log("@w Equality check between % and % is not available", ScriptUtils.simpleName(aClass), ScriptUtils.simpleName(bClass));
            } else {
                if (aClass.equals(String.class) || PrimitiveUtils.isPrimitive(aClass, true)) {
                    return a.equals(b);
                }
                LogUtils.log("@w Equality check is only effective for numbers, strings, and boolean values. It returns false in other cases");
            }
        }
        return false;
    }

    public static Pair<Function, NativeJavaObject> prepareSubflow(String qname, Map<String, String> mapping) throws IOException {
        return ((FlowService)CdiUtil.bean(FlowService.class)).prepareSubflow(qname, mapping);
    }

    public static Pair<Object, Exception> callAction(Object instance, String actionClassName, String methodName, Object[] params) {
        Object result = null;
        Exception ex = null;
        try {
            if (instance == null && actionClassName == null) {
                ex = new IllegalArgumentException("Cannot call method " + methodName + " of null");
            } else {
                result = ((ActionService)CdiUtil.bean(ActionService.class)).callAction(instance, actionClassName, methodName, params);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception raised when executing Call - class: {}, method: {}", (Object)(actionClassName == null ? instance.getClass().getName() : actionClassName), (Object)methodName);
            ex = e;
        }
        return new Pair(result, (Object)ex);
    }

    public static void closeSubflow() throws IOException {
        ((FlowService)CdiUtil.bean(FlowService.class)).closeSubflow();
    }

    public static Map<String, String> templatesMapping(String parentBasepath, String[] overrides) throws AccessDeniedException, URISyntaxException {
        String slBasepath = parentBasepath + "/";
        HashMap<String, String> pathOverrides = new HashMap<String, String>();
        for (int i = 0; i < overrides.length / 2; ++i) {
            String original = ScriptUtils.normalize(overrides[2 * i]);
            Object overriden = ScriptUtils.normalize(slBasepath + overrides[2 * i + 1]);
            if (((String)overriden).equals(slBasepath)) {
                int j = original.lastIndexOf("/");
                overriden = j == -1 ? original : original.substring(j + 1);
                overriden = slBasepath + (String)overriden;
            }
            pathOverrides.put(original, (String)overriden);
        }
        return pathOverrides;
    }

    public static boolean pathMatching(String url, Collection<String> paths) {
        LOG.trace("Matching {} to any of {}", (Object)url, paths);
        UnaryOperator unsuffixed = s -> s.substring(0, s.lastIndexOf("."));
        String path = (String)unsuffixed.apply(url);
        return paths.stream().map(unsuffixed).anyMatch(path::equals);
    }

    private static String normalize(String sUri) throws AccessDeniedException, URISyntaxException {
        EngineConfig engineConf = (EngineConfig)CdiUtil.bean(EngineConfig.class);
        String templatesFolder = engineConf.getRootDir() + engineConf.getTemplatesPath() + "/";
        String ret = new URI(templatesFolder + sUri).normalize().toString();
        if (!ret.startsWith(templatesFolder)) {
            throw new AccessDeniedException(ret, null, "Access outside templates folder is not allowed");
        }
        return ret.substring(templatesFolder.length());
    }

    private static String simpleName(Class<?> cls) {
        String name = List.class.isAssignableFrom(cls) ? "list" : (Map.class.isAssignableFrom(cls) ? "map" : cls.getSimpleName());
        return name;
    }
}

