/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.serialize;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.minlog.Log;
import io.jans.agama.engine.service.ActionService;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;

@ApplicationScoped
public class KryoSerializer {
    @Inject
    private Logger logger;
    @Inject
    private ActionService actionService;
    private ThreadLocal<Kryo> kryos;

    public Object deserialize(InputStream in) {
        this.logger.trace("Kryodeserializing");
        Input input = new Input(in);
        return this.kryos.get().readClassAndObject(input);
    }

    public void serialize(Object data, OutputStream out) throws IOException {
        this.logger.trace("Kryoserializing");
        Output output = new Output(out);
        this.kryos.get().writeClassAndObject(output, data);
        output.flush();
    }

    @PostConstruct
    private void init() {
        Log.DEBUG();
        this.kryos = new ThreadLocal<Kryo>(){

            @Override
            protected Kryo initialValue() {
                Kryo kryo = new Kryo();
                kryo.setRegistrationRequired(false);
                kryo.setReferences(true);
                kryo.setClassLoader((ClassLoader)KryoSerializer.this.actionService.getClassLoader());
                kryo.setOptimizedGenerics(false);
                return kryo;
            }
        };
    }
}

