/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.serialize;

import io.jans.agama.engine.serialize.KryoSerializer;
import io.jans.agama.model.EngineConfig;
import io.jans.agama.model.serialize.Type;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

@ApplicationScoped
public class SerializationUtil {
    @Inject
    private KryoSerializer criolina;
    @Inject
    private EngineConfig econfig;
    @Inject
    private Logger logger;

    public void write(Object obj, ObjectOutputStream out) throws IOException {
        Type type = this.typeFor(obj);
        this.logger.trace("Serialization strategy chosen was {}", (Object)type);
        boolean useKryo = type.equals((Object)Type.KRYO);
        out.writeBoolean(useKryo);
        if (useKryo) {
            this.criolina.serialize(obj, out);
        } else {
            out.writeObject(obj);
        }
    }

    public Object read(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return in.readBoolean() ? this.criolina.deserialize(in) : in.readObject();
    }

    private Type typeFor(Object budget) {
        Map rules = this.econfig.getSerializeRules();
        if (rules == null) {
            return Type.KRYO;
        }
        String clsName = budget.getClass().getName();
        List<String> jules = SerializationUtil.aList(rules, Type.JAVA);
        List<String> kules = SerializationUtil.aList(rules, Type.KRYO);
        int kryoScore = SerializationUtil.score(clsName, kules);
        if (kryoScore == -1) {
            return Type.KRYO;
        }
        if (Exception.class.isInstance(budget)) {
            return kryoScore == 0 ? Type.KRYO : Type.JAVA;
        }
        int jScore = SerializationUtil.score(clsName, jules);
        return kryoScore <= jScore ? Type.KRYO : Type.JAVA;
    }

    private static int score(String clsName, List<String> prefixes) {
        int parts = SerializationUtil.dotCount(clsName);
        if (parts == 0) {
            return -1;
        }
        ++parts;
        int sc = 0;
        for (String pack : prefixes) {
            if (!StringHelper.isNotEmptyString((Object)pack)) continue;
            int packageParts = SerializationUtil.dotCount(pack) + 1;
            if (parts > packageParts) {
                if (!clsName.startsWith(pack + ".") || sc >= packageParts) continue;
                sc = packageParts;
                continue;
            }
            if (parts != packageParts || !pack.equals(clsName)) continue;
            return 0;
        }
        return parts - sc;
    }

    private static int dotCount(String str) {
        int s = -1;
        int i = -1;
        do {
            ++i;
            ++s;
        } while ((i = str.indexOf(46, i)) != -1);
        return s;
    }

    private static List<String> aList(Map<String, List<String>> map, Type type) {
        return map.getOrDefault(type.toString(), Collections.emptyList());
    }
}

