/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.agama.dsl.Transpiler;
import io.jans.agama.engine.continuation.PendingException;
import io.jans.agama.engine.continuation.PendingRedirectException;
import io.jans.agama.engine.continuation.PendingRenderException;
import io.jans.agama.engine.exception.FlowCrashException;
import io.jans.agama.engine.exception.FlowTimeoutException;
import io.jans.agama.engine.misc.FlowUtils;
import io.jans.agama.engine.model.FlowResult;
import io.jans.agama.engine.model.FlowStatus;
import io.jans.agama.engine.service.AgamaPersistenceService;
import io.jans.agama.model.EngineConfig;
import io.jans.agama.model.Flow;
import io.jans.agama.model.FlowMetadata;
import io.jans.util.Pair;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ContinuationPending;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeContinuation;
import org.mozilla.javascript.NativeJavaList;
import org.mozilla.javascript.NativeJavaMap;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.slf4j.Logger;

@RequestScoped
public class FlowService {
    private static final String SESSION_ID_COOKIE = "session_id";
    private static final String SCRIPT_SUFFIX = ".js";
    private static final int TIMEOUT_SKEW = 8000;
    @Inject
    private Logger logger;
    @Inject
    private ObjectMapper mapper;
    @Inject
    private AgamaPersistenceService aps;
    @Inject
    private FlowUtils flowUtils;
    @Inject
    private EngineConfig engineConfig;
    @Inject
    private HttpServletRequest request;
    private String sessionId;
    private Context scriptCtx;
    private Scriptable globalScope;
    private Deque<Map<String, String>> parentsMappings;

    public FlowStatus getRunningFlowStatus() throws IOException {
        return this.aps.getFlowStatus(this.sessionId);
    }

    public FlowStatus startFlow(FlowStatus status) throws FlowCrashException {
        try {
            status.setStartedAt(System.currentTimeMillis());
            String flowName = status.getQname();
            Flow flow = this.aps.getFlow(flowName, true);
            FlowMetadata fl = flow.getMetadata();
            String funcName = fl.getFuncName();
            this.verifyCode(flow);
            this.logger.info("Evaluating flow code");
            try {
                this.globalScope = this.initContext(this.scriptCtx);
                this.scriptCtx.evaluateString(this.globalScope, Transpiler.UTIL_SCRIPT_CONTENTS, "util.js", 1, null);
                this.flowUtils.printScopeIds(this.globalScope);
                this.scriptCtx.evaluateString(this.globalScope, flow.getTranspiled(), flowName + SCRIPT_SUFFIX, 1, null);
                this.flowUtils.printScopeIds(this.globalScope);
                this.logger.info("Executing function {}", (Object)funcName);
                Function f = (Function)this.globalScope.get(funcName, this.globalScope);
                this.parentsMappings = status.getParentsMappings();
                Object[] params = this.getFuncParams(fl, status.getJsonInput());
                Object val = this.scriptCtx.callFunctionWithContinuations((Callable)f, this.globalScope, params);
                NativeObject result = this.checkJSReturnedValue(val);
                this.finishFlow(result, status);
            }
            catch (ContinuationPending pe) {
                status = this.processPause(pe, status);
            }
            catch (Exception e) {
                this.terminateFlow();
                this.makeCrashException(e);
            }
        }
        catch (IOException ie) {
            this.makeCrashException(ie);
        }
        return status;
    }

    public FlowStatus continueFlow(FlowStatus status, String jsonParameters, boolean callbackResume, String cancelUrl) throws FlowCrashException, FlowTimeoutException {
        try {
            if (callbackResume) {
                status.setAllowCallbackResume(false);
                this.aps.persistFlowStatus(this.sessionId, status);
            }
            try {
                this.ensureTimeNotExceeded(status);
                Pair<Scriptable, NativeContinuation> pcont = this.aps.getContinuation(this.sessionId);
                this.globalScope = (Scriptable)pcont.getFirst();
                this.flowUtils.printScopeIds(this.globalScope);
                this.logger.debug("Resuming flow");
                this.parentsMappings = status.getParentsMappings();
                Object val = this.scriptCtx.resumeContinuation(pcont.getSecond(), this.globalScope, (Object)new Pair((Object)cancelUrl, (Object)jsonParameters));
                NativeObject result = this.checkJSReturnedValue(val);
                this.finishFlow(result, status);
            }
            catch (ContinuationPending pe) {
                status = this.processPause(pe, status);
            }
            catch (FlowTimeoutException te) {
                this.terminateFlow();
                throw te;
            }
            catch (Exception e) {
                this.terminateFlow();
                this.makeCrashException(e);
            }
        }
        catch (IOException ie) {
            this.makeCrashException(ie);
        }
        return status;
    }

    public Pair<Function, NativeJavaObject> prepareSubflow(String subflowName, Map<String, String> mappings) throws IOException {
        this.logger.debug("Template mappings of subflow {} are {}", (Object)subflowName, mappings);
        Flow flow = this.aps.getFlow(subflowName, false);
        FlowMetadata fl = flow.getMetadata();
        String funcName = fl.getFuncName();
        String flowCodeFileName = subflowName + SCRIPT_SUFFIX;
        this.initContext(this.scriptCtx);
        this.scriptCtx.evaluateString(this.globalScope, flow.getTranspiled(), flowCodeFileName, 1, null);
        this.flowUtils.printScopeIds(this.globalScope);
        this.logger.info("Appending function {} to scope", (Object)funcName);
        Function f = (Function)this.globalScope.get(funcName, this.globalScope);
        this.parentsMappings.push(mappings);
        this.logger.info("Evaluating subflow code");
        Map configs = Optional.ofNullable(fl.getProperties()).orElse(Collections.emptyMap());
        return new Pair((Object)f, (Object)this.wrapListOrMap(configs));
    }

    public void ensureTimeNotExceeded(FlowStatus flstatus) throws FlowTimeoutException {
        if (System.currentTimeMillis() + 8000L > flstatus.getFinishBefore()) {
            throw new FlowTimeoutException("You have exceeded the amount of time required to complete your authentication", flstatus.getQname());
        }
    }

    public void closeSubflow() throws IOException {
        this.parentsMappings.pop();
    }

    public void terminateFlow() throws IOException {
        this.aps.terminateFlow(this.sessionId);
    }

    private void finishFlow(NativeObject result, FlowStatus status) throws IOException {
        FlowResult res = this.flowResultFrom(result);
        status.setResult(res);
        this.aps.finishFlow(this.sessionId, res);
    }

    private void verifyCode(Flow fl) throws IOException {
        String hash;
        String code = fl.getTranspiled();
        if (code == null) {
            String msg = "Source code of flow " + fl.getQname() + " ";
            msg = msg + (fl.getCodeError() == null ? "has not been parsed yet" : "has errors");
            throw new IOException(msg);
        }
        if (!Optional.ofNullable(this.engineConfig.getDisableTCHV()).orElse(false).booleanValue() && (hash = fl.getTransHash()) != null && !this.flowUtils.hash(code).equals(hash)) {
            throw new IOException("Transpiled code seems to have been altered. Restore the code by increasing this flow's jansRevision attribute");
        }
    }

    private FlowStatus processPause(ContinuationPending pending, FlowStatus status) throws IOException {
        PendingException pe = null;
        if (pending instanceof PendingRenderException) {
            PendingRenderException pre = (PendingRenderException)pending;
            String templPath = this.computeTemplatePath(pre.getTemplatePath(), this.parentsMappings);
            if (!templPath.contains(".")) {
                throw new IOException("Expecting file extension for the template to render: " + templPath);
            }
            status.setTemplatePath(templPath);
            status.setTemplateDataModel(pre.getDataModel());
            status.setExternalRedirectUrl(null);
            pe = pre;
        } else if (pending instanceof PendingRedirectException) {
            if (status.isNativeClient()) {
                throw new IOException("RFAC for native clients is not available");
            }
            PendingRedirectException pre = (PendingRedirectException)pending;
            status.setTemplatePath(null);
            status.setTemplateDataModel(null);
            status.setExternalRedirectUrl(pre.getLocation());
            pe = pre;
        } else {
            throw new IllegalArgumentException("Unexpected instance of ContinuationPending");
        }
        this.logger.debug("Parents mappings: {}", status.getParentsMappings());
        status.setAllowCallbackResume(pe.isAllowCallbackResume());
        this.aps.saveState(this.sessionId, status, pe.getContinuation(), this.globalScope);
        return status;
    }

    private String computeTemplatePath(String path, Deque<Map<String, String>> parentsMappings) {
        String result = path;
        for (Map<String, String> mapping : parentsMappings) {
            String overriden = mapping.get(result);
            if (overriden == null) continue;
            result = overriden;
        }
        this.logger.info("Inferred template for {} is {}", (Object)path, (Object)result);
        return result;
    }

    private Object[] getFuncParams(FlowMetadata metadata, String strParams) throws JsonProcessingException {
        List inputs = Optional.ofNullable(metadata.getInputs()).orElse(Collections.emptyList());
        Map configs = Optional.ofNullable(metadata.getProperties()).orElse(Collections.emptyMap());
        Object[] params = new Object[inputs.size() + 1];
        params[0] = this.wrapListOrMap(configs);
        if (strParams != null) {
            Map map = (Map)this.mapper.readValue(strParams, (TypeReference)new TypeReference<Map<String, Object>>(){});
            for (int i = 1; i < params.length; ++i) {
                params[i] = map.get(inputs.get(i - 1));
            }
        }
        for (int i = 1; i < params.length; ++i) {
            String input = (String)inputs.get(i - 1);
            if (params[i] == null) {
                this.logger.warn("Setting parameter '{}' to null", (Object)input);
                continue;
            }
            this.logger.debug("Setting parameter '{}' to an instance of {}", (Object)input, (Object)params[i].getClass().getName());
            NativeJavaObject wrapped = this.wrapListOrMap(params[i]);
            params[i] = wrapped == null ? params[i] : wrapped;
        }
        return params;
    }

    private NativeJavaObject wrapListOrMap(Object obj) {
        if (Map.class.isInstance(obj)) {
            return new NativeJavaMap(this.globalScope, obj);
        }
        if (List.class.isInstance(obj)) {
            return new NativeJavaList(this.globalScope, obj);
        }
        return null;
    }

    private NativeObject checkJSReturnedValue(Object obj) throws Exception {
        try {
            if (Undefined.isUndefined((Object)obj)) {
                throw new FlowCrashException("No Finish instruction was reached during execution of flow");
            }
            return (NativeObject)NativeObject.class.cast(obj);
        }
        catch (ClassCastException e) {
            Object ex = ((NativeJavaObject)NativeJavaObject.class.cast(obj)).unwrap();
            if (Exception.class.isInstance(ex)) {
                throw (Exception)ex;
            }
            throw new RuntimeException("Unexpected Java value received upon flow termination");
        }
    }

    private void makeCrashException(Exception e) throws FlowCrashException {
        if (FlowCrashException.class.isInstance(e)) {
            throw (FlowCrashException)e;
        }
        throw new FlowCrashException(e.getMessage(), e);
    }

    private FlowResult flowResultFrom(NativeObject result) throws JsonProcessingException {
        return (FlowResult)this.mapper.convertValue((Object)result, FlowResult.class);
    }

    private Scriptable initContext(Context ctx) {
        ctx.setLanguageVersion(200);
        ctx.setOptimizationLevel(-1);
        return ctx.initStandardObjects();
    }

    @PostConstruct
    private void init() {
        class AgamaContextFactory
        extends ContextFactory {
            AgamaContextFactory() {
            }

            protected boolean hasFeature(Context cx, int featureIndex) {
                switch (featureIndex) {
                    case 21: {
                        return true;
                    }
                }
                return super.hasFeature(cx, featureIndex);
            }
        }
        this.scriptCtx = new AgamaContextFactory().enterContext();
        this.sessionId = null;
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            this.sessionId = Stream.of(cookies).filter(coo -> coo.getName().equals(SESSION_ID_COOKIE)).findFirst().map(Cookie::getValue).orElse(null);
        }
        if (this.sessionId == null) {
            this.logger.warn("Session ID not found");
        }
    }

    @PreDestroy
    private void finish() {
        Context.exit();
    }
}

