/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.agama.engine.misc.PrimitiveUtils;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.stream.Stream;
import org.slf4j.Logger;

@ApplicationScoped
public class MethodInvoker {
    @Inject
    private Logger logger;
    private ObjectMapper mapper;

    public Object callConstructor(Class cls, Object[] args) throws Exception {
        int arity = args.length;
        PriorityQueue<AbstractMap.SimpleEntry> pq = new PriorityQueue<AbstractMap.SimpleEntry>(Comparator.comparing(se -> paramTransformation.score((List)se.getValue())));
        Stream.of(cls.getConstructors()).filter(cons -> this.acceptableExecutable((Executable)cons, arity, false)).map(cons -> new AbstractMap.SimpleEntry<Constructor, List<paramTransformation>>((Constructor)cons, this.argsTransformations((Executable)cons, args))).filter(se -> se.getValue() != null).forEach(pq::add);
        int attempts = 0;
        AbstractMap.SimpleEntry entry = pq.poll();
        while (entry != null) {
            try {
                List trs = (List)entry.getValue();
                Constructor cons2 = (Constructor)entry.getKey();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Trying to create an instance using constructor: {}", (Object)cons2.toGenericString());
                }
                ++attempts;
                return cons2.newInstance(this.applyArgsTransformations(cons2.getParameters(), args, trs));
            }
            catch (InvocationTargetException e) {
                throw (Exception)e.getCause();
            }
            catch (Exception e) {
                this.logger.error("", (Throwable)e);
                entry = pq.poll();
            }
        }
        throw new InstantiationException(String.format("Unable to find a suitable constructor with arity %d in class %s - %d attempts made", arity, cls.getName(), attempts));
    }

    public Object call(Class cls, Object instance, String methodName, Object[] args) throws Exception {
        boolean noInst = instance == null;
        int arity = args.length;
        PriorityQueue<AbstractMap.SimpleEntry> pq = new PriorityQueue<AbstractMap.SimpleEntry>(Comparator.comparing(se -> ((LMethod)se.getKey()).getLevel() + paramTransformation.score((List)se.getValue())));
        this.candidateMethodEntries(cls, methodName, arity, noInst, args).forEach(pq::add);
        int attempts = 0;
        AbstractMap.SimpleEntry entry = pq.poll();
        while (entry != null) {
            try {
                List trs = (List)entry.getValue();
                Method method = ((LMethod)entry.getKey()).getMethod();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Trying to invoke method: {}", (Object)method.toGenericString());
                }
                ++attempts;
                return method.invoke(instance, this.applyArgsTransformations(method.getParameters(), args, trs));
            }
            catch (InvocationTargetException e) {
                throw (Exception)e.getCause();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                entry = pq.poll();
            }
        }
        throw new NoSuchMethodException(String.format("Unable to find a suitable method %s with arity %d in class %s - %d attempts made", methodName, arity, cls.getName(), attempts));
    }

    private List<AbstractMap.SimpleEntry<LMethod, List<paramTransformation>>> candidateMethodEntries(Class cls, String methodName, int arity, boolean isStatic, Object[] args) {
        int l = 0;
        Class current = cls;
        ArrayList<AbstractMap.SimpleEntry<LMethod, List<paramTransformation>>> entries = new ArrayList<AbstractMap.SimpleEntry<LMethod, List<paramTransformation>>>();
        while (current != null) {
            this.logger.debug("Looking up candidate methods in class {}", (Object)current.getName());
            for (Method m : current.getDeclaredMethods()) {
                List<paramTransformation> ptrs;
                if (!m.getName().equals(methodName) || !this.acceptableExecutable(m, arity, isStatic) || (ptrs = this.argsTransformations(m, args)) == null) continue;
                entries.add(new AbstractMap.SimpleEntry<LMethod, List<paramTransformation>>(new LMethod(m, l), ptrs));
            }
            current = current.getSuperclass();
            ++l;
        }
        return entries;
    }

    private Object[] applyArgsTransformations(Parameter[] parameters, Object[] arguments, List<paramTransformation> trs) throws IllegalArgumentException {
        if (parameters.length > 0) {
            this.logger.debug("Using transformation of params: {}", trs);
        }
        Object[] javaArgs = new Object[parameters.length];
        int i = -1;
        for (Parameter p : parameters) {
            Object arg;
            Class<?> argClass = (arg = arguments[++i]) == null ? null : arg.getClass();
            Class<?> paramType = p.getType();
            String typeName = paramType.getName();
            paramTransformation ts = trs.get(i);
            Object javaArg = null;
            switch (ts) {
                case IDENTITY: {
                    javaArg = arg;
                    break;
                }
                case PRIMITIVE_NUMBER: {
                    javaArg = PrimitiveUtils.primitiveNumberFrom((Number)arg, paramType);
                    if (javaArg != null) break;
                    throw new IllegalArgumentException(String.format("Cannot convert argument of class %s to a %s", argClass.getName(), typeName));
                }
                case SINGLE_CHAR: {
                    String s = arg.toString();
                    int len = s.length();
                    if (len == 0 || len > 1) {
                        throw new IllegalArgumentException(String.format("Cannot convert argument of class %s to a %s. Length is not 1", argClass.getName(), typeName));
                    }
                    javaArg = Character.valueOf(s.charAt(0));
                    break;
                }
                case MAPPER: {
                    try {
                        Type parameterizedType = p.getParameterizedType();
                        String ptypeName = parameterizedType.getTypeName();
                        this.logger.debug("Parsing argument of class {} to {} with Object Mapper", (Object)argClass.getCanonicalName(), (Object)ptypeName);
                        JavaType javaType = this.mapper.getTypeFactory().constructType(parameterizedType);
                        javaArg = this.mapper.convertValue(arg, javaType);
                        break;
                    }
                    catch (IllegalArgumentException ie) {
                        throw ie;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                default: {
                    throw new IllegalArgumentException(String.format("Cannot handle parameter transformation %s, index %d", ts.toString(), i));
                }
            }
            javaArgs[i] = javaArg;
        }
        return javaArgs;
    }

    private List<paramTransformation> argsTransformations(Executable javaExec, Object[] arguments) {
        ArrayList<paramTransformation> trans = new ArrayList<paramTransformation>();
        int i = -1;
        this.logger.debug("Computing param transformations for executable {}", (Object)javaExec.toGenericString());
        for (Parameter p : javaExec.getParameters()) {
            Object arg = arguments[++i];
            this.logger.trace("Examining argument at index {}", (Object)i);
            Class<?> paramType = p.getType();
            String typeName = paramType.getName();
            if (arg == null) {
                if (PrimitiveUtils.isPrimitive(paramType, false)) {
                    this.logger.trace("null value passed for a primitive parameter of type {}", (Object)typeName);
                    return null;
                }
                trans.add(paramTransformation.IDENTITY);
                continue;
            }
            if (typeName.equals(Object.class.getName())) {
                this.logParamIs(typeName);
                trans.add(paramTransformation.IDENTITY);
                continue;
            }
            Class<?> argClass = arg.getClass();
            Boolean primCompat = PrimitiveUtils.compatible(argClass, paramType);
            if (primCompat != null) {
                if (primCompat.booleanValue()) {
                    this.logger.trace("Parameter is a primitive (or wrapped) {}", (Object)typeName);
                    trans.add(paramTransformation.IDENTITY);
                    continue;
                }
                if (Number.class.isAssignableFrom(argClass)) {
                    this.logger.trace("Parameter is a primitive (or wrapped) {}", (Object)typeName);
                    trans.add(paramTransformation.PRIMITIVE_NUMBER);
                    continue;
                }
                this.logMismatch(argClass, typeName);
                return null;
            }
            if (CharSequence.class.isAssignableFrom(argClass)) {
                primCompat = PrimitiveUtils.compatible(Character.class, paramType);
                if (Optional.ofNullable(primCompat).orElse(false).booleanValue()) {
                    this.logParamIs(typeName);
                    trans.add(paramTransformation.SINGLE_CHAR);
                    continue;
                }
                if (paramType.isAssignableFrom(argClass)) {
                    this.logParamIs(typeName);
                    trans.add(paramTransformation.IDENTITY);
                    continue;
                }
                if (paramType.equals(Character[].class) || paramType.equals(char[].class)) {
                    this.logParamIs(typeName);
                    trans.add(paramTransformation.MAPPER);
                    continue;
                }
                this.logMismatch(argClass, typeName);
                return null;
            }
            Type parameterizedType = p.getParameterizedType();
            String ptypeName = parameterizedType.getTypeName();
            boolean straight = false;
            if (paramType.isInstance(arg) && !(straight = ptypeName.equals(typeName)) && ParameterizedType.class.isInstance(parameterizedType)) {
                straight = Stream.of(((ParameterizedType)parameterizedType).getActualTypeArguments()).map(Type::getTypeName).allMatch("?"::equals);
            }
            this.logParamIs(ptypeName);
            trans.add(straight ? paramTransformation.IDENTITY : paramTransformation.MAPPER);
        }
        return trans;
    }

    private void logMismatch(Class<?> argClass, String typeName) {
        this.logger.trace("{} passed for a {}", (Object)argClass.getSimpleName(), (Object)typeName);
    }

    private void logParamIs(String typeName) {
        this.logger.trace("Parameter is a {}", (Object)typeName);
    }

    private boolean acceptableExecutable(Executable e, int arity, boolean staticRequired) {
        int mod = e.getModifiers();
        return e.getParameterCount() == arity && Modifier.isPublic(mod) && (!staticRequired || Modifier.isStatic(mod));
    }

    @PostConstruct
    private void init() {
        this.mapper = new ObjectMapper();
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    class LMethod {
        private Method m;
        private int level;

        LMethod(Method m, int level) {
            this.m = m;
            this.level = level;
        }

        int getLevel() {
            return this.level;
        }

        Method getMethod() {
            return this.m;
        }
    }

    static enum paramTransformation {
        IDENTITY(0),
        PRIMITIVE_NUMBER(1),
        SINGLE_CHAR(1),
        MAPPER(4);

        int weight;

        private paramTransformation(int weight) {
            this.weight = weight;
        }

        static int score(List<paramTransformation> trs) {
            return trs.stream().mapToInt(t -> t.weight).sum();
        }
    }
}

