/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.service;

import freemarker.core.OutputFormat;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import io.jans.agama.engine.exception.TemplateProcessingException;
import io.jans.agama.model.EngineConfig;
import io.jans.util.Pair;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;

@ApplicationScoped
public class TemplatingService {
    @Inject
    private Logger logger;
    @Inject
    private EngineConfig econf;
    private Configuration fmConfig;

    public Pair<String, String> process(String templatePath, Object dataModel, Writer writer, boolean useClassloader) throws TemplateProcessingException {
        try {
            Template t = useClassloader ? this.getTemplateFromClassLoader(templatePath) : this.getTemplate(templatePath);
            t.process(Optional.ofNullable(dataModel).orElse(Collections.emptyMap()), writer);
            String mime = Optional.ofNullable(t.getOutputFormat()).map(OutputFormat::getMimeType).orElse(null);
            String encoding = Optional.ofNullable(t.getEncoding()).orElse(this.fmConfig.getDefaultEncoding());
            return new Pair((Object)mime, (Object)encoding);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new TemplateProcessingException(e.getMessage(), e);
        }
    }

    private Template getTemplate(String path) throws IOException {
        return this.fmConfig.getTemplate(path);
    }

    private Template getTemplateFromClassLoader(String path) throws IOException {
        ClassLoader loader = this.getClass().getClassLoader();
        InputStreamReader reader = new InputStreamReader(loader.getResourceAsStream(path), StandardCharsets.UTF_8);
        return new Template(path, (Reader)reader, this.fmConfig);
    }

    @PostConstruct
    private void init() {
        this.fmConfig = new Configuration(Configuration.VERSION_2_3_32);
        this.fmConfig.setDefaultEncoding(StandardCharsets.UTF_8.toString());
        this.fmConfig.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.fmConfig.setLogTemplateExceptions(false);
        this.fmConfig.setWrapUncheckedExceptions(true);
        this.fmConfig.setFallbackOnNullLoopVariable(false);
        try {
            this.fmConfig.setDirectoryForTemplateLoading(Paths.get(this.econf.getRootDir(), new String[0]).toFile());
        }
        catch (IOException e) {
            this.logger.error("Error configuring directory for UI templates: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

