/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.service;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;

@RequestScoped
public class WebContext {
    @Inject
    private HttpServletRequest request;
    private String contextPath;
    private String relativePath;
    private Locale locale;

    public String getContextPath() {
        return this.contextPath;
    }

    public String getRestartUrl() {
        return this.contextPath + "/fl/restart";
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getRequestUrl() {
        Object queryString = this.request.getQueryString();
        queryString = queryString == null ? "" : "?" + (String)queryString;
        return this.request.getRequestURL().toString() + (String)queryString;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @PostConstruct
    private void init() {
        this.contextPath = this.request.getContextPath();
        this.relativePath = this.request.getServletPath();
        this.locale = this.request.getLocale();
    }
}

