/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.servlet;

import io.jans.agama.engine.exception.FlowCrashException;
import io.jans.agama.engine.exception.FlowTimeoutException;
import io.jans.agama.engine.model.FlowResult;
import io.jans.agama.engine.model.FlowStatus;
import io.jans.agama.engine.service.FlowService;
import io.jans.agama.engine.servlet.BaseServlet;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

@WebServlet(urlPatterns={"*.fls", "/fl/callback"})
public class ExecutionServlet
extends BaseServlet {
    public static final String URL_SUFFIX = ".fls";
    public static final String URL_PREFIX = "/fl/";
    public static final String CALLBACK_PATH = "/fl/callback";
    public static final String ABORT_PARAM = "_abort";
    private static final String POST_FINISH_URL_KEY = "post_finish_url";
    private static final String NO_ACTIVE_FLOW = "This flow may have already finished/timed out. Login again to the website you were trying to access originally.";
    @Inject
    private FlowService flowService;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block9: {
            FlowStatus fstatus = this.flowService.getRunningFlowStatus();
            if (fstatus == null || fstatus.getStartedAt() == -1L) {
                this.sendPageMismatch(response, NO_ACTIVE_FLOW, null);
                return;
            }
            String qname = fstatus.getQname();
            if (fstatus.getStartedAt() == 0L) {
                this.logger.info("Attempting to trigger flow {}", (Object)qname);
                try {
                    fstatus = this.flowService.startFlow(fstatus);
                    FlowResult result = fstatus.getResult();
                    if (result == null) {
                        this.sendRedirect(response, request.getContextPath(), fstatus, true);
                        break block9;
                    }
                    this.sendFinishPage(response, result, fstatus.getStartUrl());
                }
                catch (FlowCrashException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    this.sendFlowCrashed(response, e.getMessage());
                }
            } else {
                String path = request.getServletPath();
                if (this.processCallback(response, fstatus, path)) {
                    return;
                }
                String expectedUrl = this.getExpectedUrl(fstatus);
                if (path.equals(expectedUrl)) {
                    this.page.setTemplatePath(this.engineConf.getTemplatesPath() + "/" + fstatus.getTemplatePath());
                    this.page.setDataModel(fstatus.getTemplateDataModel());
                    this.sendPageContents(response, fstatus.isNativeClient());
                } else {
                    this.sendPageMismatch(response, expectedUrl, qname);
                }
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FlowStatus fstatus = this.flowService.getRunningFlowStatus();
        if (fstatus == null || fstatus.getStartedAt() == -1L) {
            this.sendPageMismatch(response, NO_ACTIVE_FLOW, null);
            return;
        }
        String path = request.getServletPath();
        if (this.processCallback(response, fstatus, path)) {
            return;
        }
        String expectedUrl = this.getExpectedUrl(fstatus);
        if (path.equals(expectedUrl)) {
            boolean aborting = request.getParameter(ABORT_PARAM) != null;
            String cancelUrl = aborting ? path.substring(URL_PREFIX.length()) : null;
            this.continueFlow(response, fstatus, false, cancelUrl);
        } else {
            this.sendPageMismatch(response, expectedUrl, fstatus.getQname());
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.flowUtils.serviceEnabled()) {
            this.sendNotAvailable(response);
            return;
        }
        String method = request.getMethod();
        String path = request.getServletPath();
        boolean match = path.startsWith(URL_PREFIX);
        if (match) {
            this.logger.debug("ExecutionServlet {} {}", (Object)method, (Object)path);
            if (method.equals("GET")) {
                this.doGet(request, response);
            } else if (method.equals("POST")) {
                this.doPost(request, response);
            } else {
                response.sendError(405);
            }
        } else {
            response.setStatus(404);
            this.logger.debug("Unexpected path {}", (Object)path);
        }
    }

    private void continueFlow(HttpServletResponse response, FlowStatus fstatus, boolean callbackResume, String cancelUrl) throws IOException {
        try {
            String jsonParams = this.isJsonRequest() ? this.request.getReader().lines().collect(Collectors.joining()) : this.flowUtils.toJsonString(this.request.getParameterMap());
            fstatus = this.flowService.continueFlow(fstatus, jsonParams, callbackResume, cancelUrl);
            FlowResult result = fstatus.getResult();
            if (result == null) {
                this.sendRedirect(response, this.request.getContextPath(), fstatus, this.request.getMethod().equals("GET"));
            } else {
                this.sendFinishPage(response, result, fstatus.getStartUrl());
            }
        }
        catch (FlowTimeoutException te) {
            this.sendFlowTimeout(response, te.getMessage());
        }
        catch (FlowCrashException ce) {
            this.logger.error(ce.getMessage(), (Throwable)ce);
            this.sendFlowCrashed(response, ce.getMessage());
        }
    }

    private boolean processCallback(HttpServletResponse response, FlowStatus fstatus, String path) throws IOException {
        if (path.equals(CALLBACK_PATH)) {
            if (fstatus.isAllowCallbackResume()) {
                this.continueFlow(response, fstatus, true, null);
            } else {
                String msg = "Unexpected incoming request to flow callback endpoint";
                this.logger.warn(msg);
                this.sendPageMismatch(response, msg, null);
            }
            return true;
        }
        return false;
    }

    private void sendRedirect(HttpServletResponse response, String contextPath, FlowStatus fls, boolean currentIsGet) throws IOException {
        Object newLocation = fls.getExternalRedirectUrl();
        if (newLocation == null) {
            newLocation = contextPath + this.getExpectedUrl(fls);
        }
        if (currentIsGet) {
            response.sendRedirect((String)newLocation);
        } else {
            response.setHeader("Location", (String)newLocation);
            response.setStatus(303);
        }
    }

    private void sendFinishPage(HttpServletResponse response, FlowResult result, String startUrl) throws IOException {
        String fpage;
        String string = fpage = this.isJsonRequest() ? this.engineConf.getJsonFinishedFlowPage() : this.engineConf.getFinishedFlowPage();
        if (startUrl != null) {
            Map<String, Object> map = Collections.singletonMap(POST_FINISH_URL_KEY, this.engineConf.getStartEndUrlMapping().get(startUrl));
            if (result.getData() == null) {
                result.setData(map);
            } else {
                result.getData().putAll(map);
            }
        }
        this.page.setTemplatePath(fpage);
        this.page.setDataModel(result);
        this.sendPageContents(response);
    }

    private String getExpectedUrl(FlowStatus fls) {
        String templPath = fls.getTemplatePath();
        if (templPath == null) {
            return null;
        }
        return URL_PREFIX + templPath.substring(0, templPath.lastIndexOf(".")) + URL_SUFFIX;
    }
}

