/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.servlet;

import io.jans.agama.NativeJansFlowBridge;
import io.jans.agama.engine.exception.FlowTimeoutException;
import io.jans.agama.engine.model.FlowStatus;
import io.jans.agama.engine.service.FlowService;
import io.jans.agama.engine.servlet.BaseServlet;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@WebServlet(urlPatterns={"/fl/restart"})
public class RestartServlet
extends BaseServlet {
    public static final String PATH = "/fl/restart";
    @Inject
    private FlowService flowService;
    @Inject
    private NativeJansFlowBridge bridge;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.flowUtils.serviceEnabled()) {
            this.sendNotAvailable(response);
            return;
        }
        this.logger.debug("Restart servlet");
        try {
            FlowStatus st = this.flowService.getRunningFlowStatus();
            if (st == null || st.getStartedAt() == -1L) {
                throw new IOException("No flow to restart");
            }
            try {
                this.flowService.ensureTimeNotExceeded(st);
                this.flowService.terminateFlow();
                this.logger.debug("Sending user's browser for a flow start");
                String url = st.getStartUrl();
                if (url == null) {
                    this.logger.warn("Check the Engine's config startEndUrlMapping");
                    throw new IOException("Unknown end url for " + url);
                }
                url = url.replaceFirst("\\.xhtml", ".htm");
                response.sendRedirect(request.getContextPath() + "/" + url);
            }
            catch (FlowTimeoutException e) {
                this.sendFlowTimeout(response, e.getMessage());
            }
        }
        catch (IOException e) {
            this.sendFlowCrashed(response, e.getMessage());
        }
    }
}

