/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.timer;

import io.jans.agama.engine.misc.FlowUtils;
import io.jans.agama.engine.model.FlowRun;
import io.jans.agama.timer.FlowRunsCleanerEvent;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

@ApplicationScoped
public class FlowRunsCleaner {
    private static final int DELAY = 120;
    private static final int INTERVAL = 90;
    private static final int GAP = 5000;
    private static final int DEL_BATCH_SIZE = 100;
    @Inject
    private Logger logger;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private FlowUtils futils;
    private AtomicBoolean isActive;

    public void initTimer() {
        this.logger.info("Initializing Agama runs cleaner Timer");
        this.isActive = new AtomicBoolean(false);
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(120, 90), (Object)new FlowRunsCleanerEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void run(@Observes @Scheduled FlowRunsCleanerEvent event) {
        if (!this.futils.serviceEnabled()) {
            return;
        }
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            int count = this.clean();
            this.logger.info("Flows cleaner timer has run. {} runs removed", (Object)count);
        }
        catch (Exception e) {
            this.logger.error("An error occurred while running flows cleaner timer", (Throwable)e);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private int clean() {
        int removed;
        Date date = new Date(System.currentTimeMillis() - 5000L);
        int total = 0;
        do {
            removed = this.entryManager.remove("ou=runs,ou=agama,o=jans", FlowRun.class, Filter.createLessOrEqualFilter((String)"exp", (Object)this.entryManager.encodeTime("ou=runs,ou=agama,o=jans", date)), 100);
            total += removed;
            this.logger.trace("{} entries removed", (Object)removed);
        } while (removed > 0);
        return total;
    }
}

