/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ads;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.ads.model.Deployment;
import io.jans.ads.model.DeploymentDetails;
import io.jans.ads.model.ProjectMetadata;
import io.jans.agama.dsl.TranspilationResult;
import io.jans.agama.dsl.Transpiler;
import io.jans.agama.dsl.TranspilerException;
import io.jans.agama.dsl.error.SyntaxException;
import io.jans.agama.engine.misc.FlowUtils;
import io.jans.agama.engine.service.AgamaPersistenceService;
import io.jans.agama.engine.service.LabelsService;
import io.jans.agama.model.Flow;
import io.jans.agama.model.FlowMetadata;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionMethod;
import org.slf4j.Logger;

@ApplicationScoped
public class Deployer {
    private static final String BASE_DN = "ou=deployments,ou=agama,o=jans";
    private static final String CUST_LIBS_DIR = "/opt/jans/jetty/jans-auth/custom/libs";
    private static final String ASSETS_DIR = "/opt/jans/jetty/jans-auth/agama";
    private static final String[] ASSETS_SUBDIRS = new String[]{"ftl", "fl"};
    private static final String SCRIPTS_SUBDIR = "scripts";
    private static final String[] TEMPLATES_EXTENSIONS = new String[]{"ftl", "ftlh", "txt"};
    private static final String[] SCRIPTS_EXTENSIONS = new String[]{"java", "groovy"};
    private static final String FLOW_EXT = "flow";
    private static final String METADATA_FILE = "project.json";
    private static final boolean ON_CONTAINERS = System.getenv("CN_VERSION") != null;
    private static final long DEPLOY_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    private static final Pattern BP_PATT = Pattern.compile("\n[ \\t]+Basepath[ \\t]+\"");
    @Inject
    private ObjectMapper mapper;
    @Inject
    private Logger logger;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    private FlowUtils futils;
    @Inject
    private AgamaPersistenceService aps;
    @Inject
    private LabelsService lbls;
    private Base64.Encoder b64Encoder;
    private Base64.Decoder b64Decoder;
    private Map<String, Long> projectsFinishTimes;
    private Map<String, Set<String>> projectsBasePaths;
    private Map<String, Set<String>> projectsFlows;
    private Map<String, Set<String>> projectsLibs;

    public void process() throws IOException {
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"jansActive", (Object)false), Filter.createPresenceFilter((String)"jansStartDate")});
        List depls = this.entryManager.findEntries(BASE_DN, Deployment.class, filter, new String[]{"jansId", "jansStartDate", "jansEndDate", "adsPrjDeplDetails"});
        Deployment dep = depls.stream().filter(d -> d.getFinishedAt() == null).min((d1, d2) -> d1.getCreatedAt().compareTo(d2.getCreatedAt())).orElse(null);
        if (dep == null) {
            this.updateFlowsAndAssets(depls);
            filter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"jansActive", (Object)true), Filter.createNOTFilter((Filter)Filter.createPresenceFilter((String)"jansEndDate"))});
            this.removeStaleDeployments(this.entryManager.findEntries(BASE_DN, Deployment.class, filter, new String[]{"jansId", "jansStartDate"}), System.currentTimeMillis());
        } else {
            this.deployProject(dep.getDn(), dep.getId(), dep.getDetails().isAutoconfigure(), dep.getDetails().getProjectMetadata().getProjectName());
        }
    }

    private void deployProject(String dn, String prjId, boolean autoconf, String name) throws IOException {
        this.logger.info("Deploying project {}", (Object)name);
        DeploymentDetails dd = new DeploymentDetails();
        Deployment dep = (Deployment)this.entryManager.find((Object)dn, Deployment.class, null);
        String b64EncodedAssets = dep.getAssets();
        dep.setTaskActive(true);
        dep.setAssets(null);
        this.logger.info("Marking deployment task as active");
        this.entryManager.merge((Object)dep);
        Path p = this.extractGamaFile(b64EncodedAssets);
        String tmpdir = p.toString();
        dd.setProjectMetadata(this.computeMetadata(name, tmpdir));
        Path pcode = Paths.get(tmpdir, "code");
        Path pweb = Paths.get(tmpdir, "web");
        Path plib = Paths.get(tmpdir, "lib");
        if (Files.isDirectory(pcode, new LinkOption[0]) && Files.isDirectory(pweb, new LinkOption[0])) {
            try {
                String prjBasepath = this.makeShortSafePath(prjId);
                Set<String> flowIds = this.createFlows(pcode, dd, prjBasepath, autoconf);
                if (dd.getError() == null) {
                    this.projectsFlows.put(prjId, flowIds);
                    ZipFile zip = this.compileAssetsArchive(p, pweb, plib, prjBasepath);
                    byte[] bytes = this.extractZipFileWithPurge(zip, ASSETS_DIR, this.projectsBasePaths.get(prjId), this.projectsLibs.get(prjId));
                    Set<String> basePaths = Set.of(prjBasepath);
                    this.projectsBasePaths.put(prjId, basePaths);
                    Set<String> libsPaths = this.transferJarFiles(plib);
                    libsPaths.addAll(this.computeSourcePaths(plib));
                    this.projectsLibs.put(prjId, libsPaths);
                    dd.setFolders(new ArrayList<String>(basePaths));
                    dd.setLibs(new ArrayList<String>(libsPaths));
                    dep.setAssets(new String(this.b64Encoder.encode(bytes), StandardCharsets.UTF_8));
                    this.lbls.addLabels(prjBasepath);
                }
            }
            catch (Exception e) {
                String msg = e.getMessage();
                this.logger.error(msg, (Throwable)e);
                dd.setError("An error occurred: " + msg);
            }
        } else {
            this.logger.warn("This does not seem to be a .gama file");
            dd.setError("Archive missing web and/or code subdirectories");
        }
        dep.setDetails(dd);
        dep.setTaskActive(false);
        Date d = new Date();
        dep.setFinishedAt(d);
        if (dd.getError() != null) {
            this.logger.warn("Deployment of project {} was not successful: {}", (Object)name, (Object)dd.getError());
        }
        this.logger.info("Finishing deployment task...");
        this.entryManager.merge((Object)dep);
        this.projectsFinishTimes.put(prjId, d.getTime());
        try {
            this.logger.debug("Cleaning .gama extraction dir");
            Deployer.removeDir(p);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private Set<String> createFlows(Path dir, DeploymentDetails dd, String prjBasepath, boolean autoconfigure) throws IOException {
        BiPredicate<Path, BasicFileAttributes> matcher = (path, attrs) -> attrs.isRegularFile() && path.getFileName().toString().endsWith(".flow");
        this.logger.info("Looking for .{} files under {}", (Object)FLOW_EXT, (Object)dir);
        Map<Path, String> flowsCode = Files.find(dir, 3, matcher, new FileVisitOption[0]).collect(Collectors.toMap(p -> p, p -> ""));
        flowsCode = new HashMap<Path, String>(flowsCode);
        Set<Path> flowsPaths = flowsCode.keySet();
        for (Path p2 : flowsPaths) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Reading {}", (Object)p2.getFileName());
            }
            flowsCode.put(p2, Files.readString(p2));
        }
        if (flowsPaths.isEmpty()) {
            dd.setError("There are no flows in this archive");
        } else {
            this.logger.debug("Flows' basepaths will all be prefixed with '{}'", (Object)prjBasepath);
        }
        HashMap<String, String> flowsOutcome = new HashMap<String, String>();
        ProjectMetadata prjMetadata = dd.getProjectMetadata();
        List noDirectLaunch = Optional.ofNullable(prjMetadata.getNoDirectLaunchFlows()).orElse(Collections.emptyList());
        Map configHints = Optional.ofNullable(prjMetadata.getConfigHints()).orElse(Collections.emptyMap());
        for (Path p3 : flowsPaths) {
            Object error = null;
            String source = flowsCode.get(p3);
            String qname = p3.getFileName().toString();
            try {
                source = this.insertProjectBasepath(source, prjBasepath);
                qname = qname.substring(0, qname.length() - FLOW_EXT.length() - 1);
                this.logger.info("Processing flow {}", (Object)qname);
                TranspilationResult tresult = Transpiler.transpile((String)qname, (String)source);
                this.logger.info("Successful transpilation");
                Flow fl = this.aps.getFlow(qname, true);
                boolean add = fl == null;
                FlowMetadata prvMeta = null;
                if (add) {
                    fl = new Flow();
                } else {
                    this.logger.info("Flow already existing in DB");
                    prvMeta = fl.getMetadata();
                }
                FlowMetadata meta = fl.getMetadata();
                meta.setFuncName(tresult.getFuncName());
                meta.setInputs(tresult.getInputs());
                meta.setTimeout(tresult.getTimeout());
                meta.setTimestamp(System.currentTimeMillis());
                meta.setAuthor(prjMetadata.getAuthor());
                if (prvMeta != null) {
                    meta.setDisplayName(prvMeta.getDisplayName());
                    meta.setDescription(prvMeta.getDescription());
                    meta.setProperties(prvMeta.getProperties());
                }
                if (autoconfigure) {
                    this.logger.warn("Setting flow configuration as provided in project archive");
                    meta.setProperties((Map)configHints.get(qname));
                }
                String compiled = tresult.getCode();
                fl.setMetadata(meta);
                fl.setSource(source);
                fl.setTranspiled(compiled);
                fl.setQname(qname);
                fl.setTransHash(this.futils.hash(compiled));
                fl.setEnabled(!noDirectLaunch.contains(qname));
                if (add) {
                    fl.setDn(Deployer.dnFromQname(qname));
                    this.logger.info("Persisting flow {}", (Object)qname);
                    this.entryManager.persist((Object)fl);
                } else {
                    this.logger.info("Updating flow {}", (Object)qname);
                    this.entryManager.merge((Object)fl);
                }
            }
            catch (SyntaxException se) {
                error = se.getMessage();
            }
            catch (TranspilerException te) {
                error = te.getMessage();
                if (te.getCause() != null) {
                    error = (String)error + "\n" + te.getCause().getMessage();
                }
            }
            catch (Exception e) {
                error = e.getMessage();
                this.logger.error((String)error, (Throwable)e);
            }
            if (error != null) {
                this.logger.error("Transpilation failed!");
                if (dd.getError() == null) {
                    dd.setError("There were problems processing one or more flows");
                }
            }
            flowsOutcome.put(qname, (String)error);
        }
        dd.setFlowsError(flowsOutcome);
        return new HashSet<String>(flowsOutcome.keySet());
    }

    private ZipFile compileAssetsArchive(Path root, Path webroot, Path lib, String prjBasepath) throws IOException {
        Path agama = Files.createDirectory(Paths.get(root.toString(), Deployer.rndName()), new FileAttribute[0]);
        String agamStr = agama.toString();
        this.logger.debug("Created temp directory");
        Path ftl = Files.createDirectories(Paths.get(agamStr, "ftl", prjBasepath), new FileAttribute[0]);
        Path fl = Files.createDirectories(Paths.get(agamStr, "fl", prjBasepath), new FileAttribute[0]);
        Path scripts = Files.createDirectory(Paths.get(agamStr, SCRIPTS_SUBDIR), new FileAttribute[0]);
        this.logger.debug("Copying templates to {}", (Object)ftl);
        Files.walkFileTree(webroot, Deployer.copyVisitor(webroot, ftl, TEMPLATES_EXTENSIONS, true));
        this.logger.debug("Copying assets to {}", (Object)fl);
        Files.walkFileTree(webroot, Deployer.copyVisitor(webroot, fl, TEMPLATES_EXTENSIONS, false));
        if (Files.isDirectory(lib, new LinkOption[0])) {
            this.logger.debug("Copying .java and .groovy sources to {}", (Object)scripts);
            Files.walkFileTree(lib, Deployer.copyVisitor(lib, scripts, SCRIPTS_EXTENSIONS, true));
        }
        ZipParameters params = new ZipParameters();
        params.setCompressionMethod(CompressionMethod.STORE);
        Path newZipPath = Paths.get(root.toString(), Deployer.rndName());
        this.logger.info("Compressing to {}", (Object)newZipPath);
        ZipFile newZip = new ZipFile(newZipPath.toFile());
        newZip.addFolder(ftl.toFile().getParentFile(), params);
        newZip.addFolder(fl.toFile().getParentFile(), params);
        newZip.addFolder(scripts.toFile(), params);
        return newZip;
    }

    private Set<String> computeSourcePaths(Path lib) throws IOException {
        BiPredicate<Path, BasicFileAttributes> matcher = (path, attrs) -> attrs.isRegularFile() && Stream.of(SCRIPTS_EXTENSIONS).anyMatch(ext -> path.getFileName().toString().endsWith("." + ext));
        if (Files.isDirectory(lib, new LinkOption[0])) {
            String slib = lib.toString();
            try (Stream<Path> stream = Files.find(lib, 20, matcher, new FileVisitOption[0]);){
                Set<String> set = stream.map(Path::toString).map(s -> s.substring(slib.length() + 1)).collect(Collectors.toSet());
                return set;
            }
        }
        return Collections.emptySet();
    }

    private Set<String> transferJarFiles(Path lib) throws IOException {
        HashSet<String> paths = new HashSet<String>();
        if (!ON_CONTAINERS && Files.isDirectory(lib, new LinkOption[0])) {
            BiPredicate<Path, BasicFileAttributes> matcher = (path, attrs) -> attrs.isRegularFile() && path.getFileName().toString().endsWith(".jar");
            List list = null;
            try (Stream<Path> stream = Files.find(lib, 1, matcher, new FileVisitOption[0]);){
                list = stream.collect(Collectors.toList());
            }
            this.logger.debug("Moving {} jar files to custom libs dir", (Object)list.size());
            for (Path jar : list) {
                String fn = jar.getFileName().toString();
                paths.add(fn);
                Files.move(jar, Paths.get(CUST_LIBS_DIR, fn), StandardCopyOption.REPLACE_EXISTING);
                this.logger.debug("{} moved", (Object)fn);
            }
        }
        return paths;
    }

    private void updateFlowsAndAssets(List<Deployment> deployments) {
        this.logger.info("Syncing in-memory state with DB state");
        HashSet<String> actualPrjIds = new HashSet<String>();
        List depls = deployments.stream().filter(d -> d.getFinishedAt() != null && d.getDetails().getError() == null).collect(Collectors.toList());
        this.logger.info("{} successful deployments found", (Object)depls.size());
        for (Object d2 : depls) {
            String prjId = d2.getId();
            actualPrjIds.add(prjId);
            String name = d2.getDetails().getProjectMetadata().getProjectName();
            Long finishedAt = this.projectsFinishTimes.get(prjId);
            if (finishedAt == null || finishedAt < d2.getFinishedAt().getTime()) {
                try {
                    String b64EncodedAssets = ((Deployment)this.entryManager.find((Object)d2.getDn(), Deployment.class, new String[]{"adsPrjAssets"})).getAssets();
                    if (finishedAt != null) {
                        this.purge(this.projectsBasePaths.get(prjId), this.projectsLibs.get(prjId));
                    }
                    if (b64EncodedAssets != null) {
                        this.extract(b64EncodedAssets, ASSETS_DIR);
                    }
                    this.logger.info("Assets of project {} were synced", (Object)name);
                    this.lbls.addLabels(this.makeShortSafePath(prjId));
                    this.projectsFinishTimes.put(prjId, d2.getFinishedAt().getTime());
                }
                catch (Exception e) {
                    this.logger.error("Error syncing assets of project " + name, (Throwable)e);
                }
                continue;
            }
            this.logger.info("Assets of project {} are already synced to disk", (Object)name);
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (String prjId : this.projectsFlows.keySet()) {
            if (actualPrjIds.contains(prjId)) continue;
            this.logger.info("Project with id {} has been removed recently. Removing references...", (Object)prjId);
            Set<String> basePaths = this.projectsBasePaths.get(prjId);
            try {
                toRemove.addAll((Collection<String>)this.projectsLibs.get(prjId));
                this.projectsFinishTimes.remove(prjId);
                this.purge(basePaths, null);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
            this.removeFlows(this.projectsFlows.get(prjId));
            this.lbls.removeLabels(basePaths.toArray(new String[0])[0]);
        }
        this.projectsFlows.clear();
        this.projectsBasePaths.clear();
        this.projectsLibs.clear();
        for (Deployment d3 : depls) {
            String prjId = d3.getId();
            DeploymentDetails dd = d3.getDetails();
            Set set = Optional.ofNullable(dd.getFlowsError()).map(Map::keySet).orElse(new HashSet());
            this.projectsFlows.put(prjId, set);
            set = Optional.ofNullable(dd.getFolders()).map(HashSet::new).orElse(new HashSet());
            this.projectsBasePaths.put(prjId, set);
            set = Optional.ofNullable(dd.getLibs()).map(HashSet::new).orElse(new HashSet());
            this.projectsLibs.put(prjId, set);
            toRemove.removeAll(set);
        }
        try {
            this.purge(null, toRemove);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
    }

    private void removeFlows(Set<String> flows) {
        for (String flow : flows) {
            try {
                String dn = Deployer.dnFromQname(flow);
                if (!this.entryManager.contains(dn, Flow.class)) continue;
                this.logger.info("Removing flow {}", (Object)flow);
                this.entryManager.remove(dn, Flow.class);
            }
            catch (Exception e) {
                this.logger.error("Error removing flow " + flow, (Throwable)e);
            }
        }
    }

    private ProjectMetadata computeMetadata(String name, String path) {
        ProjectMetadata meta = new ProjectMetadata();
        Path p = Paths.get(path, METADATA_FILE);
        if (!Files.isRegularFile(p, new LinkOption[0])) {
            this.logger.warn("Archive has no metadata file");
        } else {
            try {
                meta = (ProjectMetadata)this.mapper.readValue(Files.readString(p, StandardCharsets.UTF_8), ProjectMetadata.class);
            }
            catch (IOException e) {
                this.logger.error("Unable to read archive metadata", (Throwable)e);
            }
        }
        meta.setProjectName(name);
        return meta;
    }

    private void removeStaleDeployments(List<Deployment> deployments, long instant) {
        for (Deployment d : deployments) {
            if (d.getCreatedAt().getTime() + DEPLOY_TIMEOUT >= instant) continue;
            try {
                String prjId = d.getId();
                this.logger.info("Removing stale deployment {}", (Object)prjId);
                this.entryManager.remove(d.getDn(), Deployment.class);
            }
            catch (Exception e) {
                this.logger.error("Error removing deployment", (Throwable)e);
            }
        }
    }

    private static String dnFromQname(String qname) {
        return String.format("%s=%s,%s", "agFlowQname", qname, "ou=flows,ou=agama,o=jans");
    }

    private void purge(Set<String> dirs, Set<String> filesToRemove) throws IOException {
        if (dirs != null) {
            for (String dir : dirs) {
                for (String subdir : ASSETS_SUBDIRS) {
                    Path p = Paths.get(ASSETS_DIR, subdir, dir);
                    if (!Files.isDirectory(p, new LinkOption[0])) continue;
                    this.logger.info("Flushing folder {}", (Object)p);
                    Deployer.removeDir(p);
                }
            }
        }
        if (filesToRemove == null) {
            return;
        }
        for (String f : filesToRemove) {
            Path p = null;
            p = f.endsWith(".jar") ? Paths.get(CUST_LIBS_DIR, f) : Paths.get(ASSETS_DIR, SCRIPTS_SUBDIR, f);
            this.logger.debug("Removing file {}", (Object)f);
            Files.deleteIfExists(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extract(String b64EncodedAssets, String destination) throws IOException {
        if (b64EncodedAssets == null) {
            return;
        }
        Path p = Files.createTempFile(Deployer.rndName(), null, new FileAttribute[0]);
        this.logger.debug("Dumping decoded Base64 representation to {}", (Object)p);
        Files.write(p, this.b64Decoder.decode(b64EncodedAssets.getBytes(StandardCharsets.UTF_8)), new OpenOption[0]);
        try (ZipFile zip = new ZipFile(p.toFile());){
            this.logger.info("Extracting contents of {} to {}", (Object)p, (Object)destination);
            zip.extractAll(destination);
        }
        finally {
            this.logger.trace("Removing temp file");
            Files.delete(p);
        }
    }

    private Path extractGamaFile(String b64EncodedContents) throws IOException {
        Path p = Files.createTempDirectory(Deployer.rndName(), new FileAttribute[0]);
        this.logger.info("Extracting .gama file to {}", (Object)p);
        this.extract(b64EncodedContents, p.toString());
        return p;
    }

    private byte[] extractZipFileWithPurge(ZipFile zip, String destination, Set<String> dirsPurge, Set<String> filesToRemove) throws IOException {
        Path zipPath = zip.getFile().toPath();
        this.purge(dirsPurge, filesToRemove);
        this.logger.debug("Extracting contents of {} to {}", (Object)zipPath, (Object)destination);
        zip.extractAll(destination);
        return Files.readAllBytes(zipPath);
    }

    private static void removeDir(Path p) throws IOException {
        Files.walkFileTree(p, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (e == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw e;
            }
        });
    }

    private static FileVisitor copyVisitor(final Path source, final Path target, String[] extensions, final boolean include) {
        final List suffixes = Stream.of(extensions).map(s -> "." + s).collect(Collectors.toList());
        return new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                block2: {
                    Path targetdir = target.resolve(source.relativize(dir));
                    try {
                        Files.copy(dir, targetdir, new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException e) {
                        if (Files.isDirectory(targetdir, new LinkOption[0])) break block2;
                        throw e;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String fn = file.getFileName().toString().toLowerCase();
                boolean match = suffixes.stream().anyMatch(fn::endsWith);
                if (match && include || !match && !include) {
                    Files.copy(file, target.resolve(source.relativize(file)), new CopyOption[0]);
                }
                return FileVisitResult.CONTINUE;
            }
        };
    }

    private static String rndName() {
        return ("" + Math.random()).substring(2);
    }

    private String insertProjectBasepath(String code, String basepath) {
        Matcher m = BP_PATT.matcher(code);
        if (m.find()) {
            int i = m.end();
            if (!m.find()) {
                return code.substring(0, i) + basepath + "/" + code.substring(i);
            }
        }
        return code;
    }

    private String makeShortSafePath(String id) {
        String path;
        return path.substring((path = Integer.toString(id.hashCode(), Math.min(36, 36))).charAt(0) == '-' ? 1 : 0);
    }

    @PostConstruct
    private void init() {
        this.b64Encoder = Base64.getEncoder();
        this.b64Decoder = Base64.getDecoder();
        this.projectsBasePaths = new HashMap<String, Set<String>>();
        this.projectsFinishTimes = new HashMap<String, Long>();
        this.projectsFlows = new HashMap<String, Set<String>>();
        this.projectsLibs = new HashMap<String, Set<String>>();
    }
}

