/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.serialize;

import io.jans.agama.engine.serialize.SerializationUtil;
import io.jans.agama.engine.service.ActionService;
import io.jans.agama.engine.service.ManagedBeanService;
import io.jans.service.cdi.util.CdiUtil;
import io.jans.util.Pair;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaList;
import org.mozilla.javascript.NativeJavaMap;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeJavaBox
implements Serializable {
    private static final long serialVersionUID = 3843792598994958978L;
    private static final Logger logger = LoggerFactory.getLogger(NativeJavaBox.class);
    private static final ManagedBeanService MBSRV = (ManagedBeanService)CdiUtil.bean(ManagedBeanService.class);
    private static final SerializationUtil INUTIL = (SerializationUtil)CdiUtil.bean(SerializationUtil.class);
    private static final ActionService ACTSRV = (ActionService)CdiUtil.bean(ActionService.class);
    private NativeJavaObject raw;
    private Object unwrapped;

    public NativeJavaBox(NativeJavaObject raw) {
        this.raw = raw;
        this.unwrapped = raw.unwrap();
        if (NativeJavaObject.class.isInstance(this.unwrapped)) {
            throw new UnsupportedOperationException("Unexpected NativeJavaObject inside a NativeJavaObject");
        }
        logger.trace("NativeJavaBox created");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        String rawClsName = this.raw.getClass().getName();
        logger.trace("{} to the output stream", (Object)rawClsName);
        out.writeUTF(rawClsName);
        out.writeObject(this.raw.getParentScope());
        logger.trace("Underlying object is an instance of {}", (Object)this.unwrapped.getClass().getName());
        Pair<Class<?>, Set<Annotation>> metadata = MBSRV.getBeanMetadata(this.unwrapped);
        Class cdiBeanClass = (Class)metadata.getFirst();
        boolean cdiBean = cdiBeanClass != null;
        out.writeBoolean(cdiBean);
        if (cdiBean) {
            String realClassName = cdiBeanClass.getName();
            Set qualies = (Set)metadata.getSecond();
            logger.trace("Managed bean class {}", (Object)realClassName);
            out.writeUTF(realClassName);
            out.writeObject(qualies);
        } else {
            INUTIL.write(this.unwrapped, out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Class<?> rawCls = ACTSRV.classFromName(in.readUTF());
        logger.trace("{} in the input stream", (Object)rawCls.getName());
        Scriptable parentScope = (Scriptable)in.readObject();
        boolean cdiBean = in.readBoolean();
        if (cdiBean) {
            String realClassName = in.readUTF();
            Set qualies = (Set)in.readObject();
            logger.trace("Managed bean class {}", (Object)realClassName);
            this.unwrapped = ManagedBeanService.instance(ACTSRV.classFromName(realClassName), qualies);
        } else {
            this.unwrapped = INUTIL.read(in);
        }
        logger.trace("Underlying object is an instance of {}", (Object)this.unwrapped.getClass().getName());
        if (rawCls.equals(NativeJavaObject.class)) {
            this.raw = new NativeJavaObject(parentScope, this.unwrapped, this.unwrapped.getClass());
        } else if (rawCls.equals(NativeJavaClass.class)) {
            this.raw = new NativeJavaClass(parentScope, (Class)this.unwrapped);
        } else if (rawCls.equals(NativeJavaList.class)) {
            this.raw = new NativeJavaList(parentScope, this.unwrapped);
        } else if (rawCls.equals(NativeJavaArray.class)) {
            this.raw = NativeJavaArray.wrap((Scriptable)parentScope, (Object)this.unwrapped);
        } else if (rawCls.equals(NativeJavaMap.class)) {
            this.raw = new NativeJavaMap(parentScope, this.unwrapped);
        }
    }

    public NativeJavaObject getRaw() {
        logger.trace("Returning raw instance");
        return this.raw;
    }
}

