/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.service;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import io.jans.agama.engine.service.WebContext;
import io.jans.agama.model.EngineConfig;
import io.jans.as.model.util.Pair;
import io.jans.service.cdi.util.CdiUtil;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

@ApplicationScoped
public class LabelsService
implements TemplateMethodModelEx {
    public static final String METHOD_NAME = "labels";
    private static final String LABELS_FILE = "labels.txt";
    private static final Pattern SECTION_PATT = Pattern.compile("^\\[[ \\t]*([\\w-#]+)[ \\t]*\\][ \\t]*$");
    @Inject
    private Logger logger;
    @Inject
    private EngineConfig econf;
    private Map<String, Map<String, Properties>> labelsMap;

    public String get(String key, Object ... args) {
        Pair<String, Locale> p = this.getLocalizedLabel(key, ((WebContext)CdiUtil.bean(WebContext.class)).getLocale());
        String label = (String)p.getFirst();
        if (label != null && args.length > 0) {
            label = this.formatMessage(label, (Locale)p.getSecond(), args);
        }
        return Objects.toString(label);
    }

    public Object exec(List args) throws TemplateModelException {
        int size = args.size();
        if (size == 0) {
            throw new TemplateModelException("Call to labels(...) is missing the label key");
        }
        Object key = args.get(0);
        String strKey = Objects.toString(key);
        if (!TemplateScalarModel.class.isInstance(key)) {
            throw new TemplateModelException("Unexpected key passed to labels(...) - value was " + strKey + " but string required");
        }
        Pair<String, Locale> p = this.getLocalizedLabel(strKey, ((WebContext)CdiUtil.bean(WebContext.class)).getLocale());
        String label = (String)p.getFirst();
        if (label != null && size > 1) {
            Object[] subArgs = args.subList(1, size).toArray();
            for (int i = 0; i < subArgs.length; ++i) {
                Object arg = subArgs[i];
                if (arg == null) continue;
                if (arg instanceof TemplateScalarModel) {
                    arg = ((TemplateScalarModel)arg).getAsString();
                } else if (arg instanceof TemplateNumberModel) {
                    arg = ((TemplateNumberModel)arg).getAsNumber();
                } else if (arg instanceof TemplateDateModel) {
                    arg = ((TemplateDateModel)arg).getAsDate();
                } else if (arg instanceof TemplateBooleanModel) {
                    arg = ((TemplateBooleanModel)arg).getAsBoolean();
                } else {
                    this.logger.warn("Unable to convert parameter at position {} ({}) to any of string/number/date/boolean", (Object)i, (Object)arg.toString());
                }
                subArgs[i] = arg;
            }
            label = this.formatMessage(label, (Locale)p.getSecond(), subArgs);
        }
        return new SimpleScalar(Objects.toString(label));
    }

    public void addLabels(String path) {
        Path p = Paths.get(this.econf.getRootDir(), this.econf.getTemplatesPath(), path, LABELS_FILE);
        if (!Files.exists(p, new LinkOption[0])) {
            return;
        }
        try {
            this.logger.info("Reading {}", (Object)p);
            List<String> lines = Files.readAllLines(p);
            HashMap<String, Properties> localeMap = new HashMap<String, Properties>();
            ArrayList<String> section = new ArrayList<String>();
            String locale = null;
            for (String line : lines) {
                Matcher m = SECTION_PATT.matcher(line);
                if (m.matches()) {
                    localeMap.put(locale == null ? null : locale.toLowerCase(), this.propertiesFromSection(section));
                    section = new ArrayList();
                    locale = m.group(1);
                    continue;
                }
                section.add(line);
            }
            if (!section.isEmpty()) {
                localeMap.put(locale == null ? null : locale.toLowerCase(), this.propertiesFromSection(section));
            }
            this.logger.info("Setting labels for path {}", (Object)path);
            this.labelsMap.put(path, localeMap);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void removeLabels(String path) {
        this.logger.info("Removing in-memory labels for path {}", (Object)path);
        this.labelsMap.remove(path);
    }

    private Pair<String, Locale> getLocalizedLabel(String key, Locale locale) {
        Set<String> paths = this.labelsMap.keySet();
        String label = null;
        Locale locCopy = locale;
        boolean first = true;
        do {
            if (!first) {
                locCopy = locCopy.getVariant().length() > 0 ? new Locale(locCopy.getLanguage(), locCopy.getCountry()) : (locCopy.getCountry().length() > 0 ? new Locale(locCopy.getLanguage()) : null);
            }
            first = false;
            String strLocale = Optional.ofNullable(locCopy).map(l -> l.toString().toLowerCase()).orElse(null);
            Iterator<String> it = paths.iterator();
            while (it.hasNext() && label == null) {
                String path = it.next();
                Map<String, Properties> mama = this.labelsMap.get(path);
                label = Optional.ofNullable(mama.get(strLocale)).map(m -> m.getProperty(key)).orElse(null);
            }
        } while (locCopy != null && label == null);
        return new Pair(label, (Object)locCopy);
    }

    private String formatMessage(String pattern, Locale locale, Object[] args) {
        try {
            MessageFormat mf = new MessageFormat(pattern);
            Optional.ofNullable(locale).ifPresent(mf::setLocale);
            return mf.format(args, new StringBuffer(), (FieldPosition)null).toString();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return "error!";
        }
    }

    private Properties propertiesFromSection(List<String> section) {
        String cat = section.stream().reduce("", (a, b) -> a + "\n" + b);
        Properties p = new Properties();
        try (StringReader sr = new StringReader(cat);){
            p.load(sr);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return p;
    }

    @PostConstruct
    private void init() {
        this.labelsMap = new HashMap<String, Map<String, Properties>>();
    }
}

