/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.servlet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.agama.engine.exception.TemplateProcessingException;
import io.jans.agama.engine.misc.FlowUtils;
import io.jans.agama.engine.page.BasicTemplateModel;
import io.jans.agama.engine.page.Page;
import io.jans.agama.engine.service.TemplatingService;
import io.jans.agama.model.EngineConfig;
import io.jans.util.Pair;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;

public abstract class BaseServlet
extends HttpServlet {
    private static final String TEMPLATE_PATH_KEY = "_template";
    @Inject
    protected Logger logger;
    @Inject
    protected FlowUtils flowUtils;
    @Inject
    private TemplatingService templatingService;
    @Inject
    private ObjectMapper mapper;
    @Inject
    protected EngineConfig engineConf;
    @Inject
    protected Page page;
    @Inject
    protected HttpServletRequest request;

    protected boolean isJsonRequest() {
        return "application/json".equals(this.request.getContentType());
    }

    protected void sendNotAvailable(HttpServletResponse response) throws IOException {
        response.sendError(503, "Flow engine not available. Check if Agama has been enabled in your configuration.");
    }

    protected void sendFlowTimeout(HttpServletResponse response, String message) throws IOException {
        response.setStatus(410);
        String errorPage = this.engineConf.getInterruptionErrorPage();
        this.page.setTemplatePath(this.errorPath(errorPage));
        this.page.setDataModel(new BasicTemplateModel(message));
        this.sendPageContents(response);
    }

    protected void sendFlowCrashed(HttpServletResponse response, String error) throws IOException {
        response.setStatus(500);
        String errorPage = this.engineConf.getCrashErrorPage();
        this.page.setTemplatePath(this.errorPath(errorPage));
        this.page.setDataModel(new BasicTemplateModel(error));
        this.sendPageContents(response);
    }

    protected void sendPageMismatch(HttpServletResponse response, String message, String flowQname) throws IOException {
        response.setStatus(404);
        String errorPage = this.engineConf.getPageMismatchErrorPage();
        this.page.setTemplatePath(this.errorPath(errorPage));
        this.page.setDataModel(new BasicTemplateModel(message, flowQname));
        this.sendPageContents(response);
    }

    protected void sendPageContents(HttpServletResponse response) throws IOException {
        this.sendPageContents(response, false);
    }

    protected void sendPageContents(HttpServletResponse response, boolean nativeClient) throws IOException {
        try {
            if (nativeClient) {
                String simplePath = this.shortenPath(this.page.getTemplatePath(), 2);
                Object model = this.page.getAugmentedDataModel(false, Map.of(TEMPLATE_PATH_KEY, simplePath));
                String entity = this.mapper.writeValueAsString(model);
                this.processResponse(response, StandardCharsets.UTF_8.toString(), "application/json", entity);
            } else {
                this.processTemplate(response, this.page.getTemplatePath(), this.page.getAugmentedDataModel(true, null));
            }
        }
        catch (JsonProcessingException | TemplateProcessingException e) {
            try {
                response.setStatus(500);
                String templatePath = this.errorPath(this.engineConf.getCrashErrorPage());
                this.processTemplate(response, templatePath, new BasicTemplateModel(e.getMessage()));
            }
            catch (TemplateProcessingException e2) {
                response.sendError(500, e2.getMessage());
            }
        }
    }

    private String errorPath(String page) {
        return this.isJsonRequest() ? this.engineConf.getJsonErrorPage(page) : page;
    }

    private void processTemplate(HttpServletResponse response, String path, Object dataModel) throws TemplateProcessingException, IOException {
        StringWriter sw = new StringWriter();
        Pair<String, String> contentType = this.templatingService.process(path, dataModel, sw, false);
        this.processResponse(response, (String)contentType.getSecond(), (String)contentType.getFirst(), sw.toString());
    }

    private void processResponse(HttpServletResponse response, String charset, String mediaType, String entity) throws IOException {
        response.setCharacterEncoding(charset);
        this.engineConf.getDefaultResponseHeaders().forEach((h, v) -> response.setHeader(h, v));
        if (mediaType != null) {
            response.setContentType(mediaType);
        }
        response.getWriter().write(entity);
    }

    private String shortenPath(String str, int subPaths) {
        int j;
        int idx = str.charAt(0) == '/' ? 1 : 0;
        for (int i = 0; i < subPaths && (j = str.indexOf("/", idx)) != -1; ++i) {
            idx = j + 1;
        }
        return str.substring(idx);
    }
}

