/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.serialize;

import io.jans.agama.engine.serialize.NativeJavaBox;
import io.jans.agama.engine.service.ActionService;
import io.jans.util.Pair;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.mozilla.javascript.NativeContinuation;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;

@ApplicationScoped
public class ContinuationSerializer {
    @Inject
    private ActionService actionService;

    public byte[] save(Scriptable scope, NativeContinuation continuation) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            class CustomObjectOutputStream
            extends ObjectOutputStream {
                CustomObjectOutputStream(OutputStream out) throws IOException {
                    super(out);
                    this.enableReplaceObject(true);
                }

                @Override
                protected Object replaceObject(Object obj) throws IOException {
                    if (NativeJavaObject.class.isInstance(obj)) {
                        return new NativeJavaBox((NativeJavaObject)obj);
                    }
                    return super.replaceObject(obj);
                }
            }
            try (CustomObjectOutputStream sos = new CustomObjectOutputStream(baos);){
                sos.writeObject(new Object[]{scope, continuation});
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Pair<Scriptable, NativeContinuation> restore(byte[] data) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            Pair pair;
            class CustomObjectInputStream
            extends ObjectInputStream {
                public CustomObjectInputStream(InputStream in) throws IOException {
                    super(in);
                    this.enableResolveObject(true);
                }

                @Override
                public Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    return ContinuationSerializer.this.actionService.classFromName(desc.getName());
                }

                @Override
                protected Object resolveObject(Object obj) throws IOException {
                    if (obj != null && obj.getClass().equals(NativeJavaBox.class)) {
                        return ((NativeJavaBox)obj).getRaw();
                    }
                    return super.resolveObject(obj);
                }
            }
            try (CustomObjectInputStream sis = new CustomObjectInputStream(bais);){
                Object[] arr = (Object[])sis.readObject();
                pair = new Pair((Object)((Scriptable)arr[0]), (Object)((NativeContinuation)arr[1]));
            }
            return pair;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }
}

