/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.engine.service;

import io.jans.agama.engine.misc.FlowUtils;
import io.jans.agama.engine.model.FlowResult;
import io.jans.agama.engine.model.FlowRun;
import io.jans.agama.engine.model.FlowStatus;
import io.jans.agama.engine.model.ProtoFlowRun;
import io.jans.agama.engine.serialize.ContinuationSerializer;
import io.jans.agama.model.Flow;
import io.jans.agama.model.ProtoFlow;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import io.jans.util.Pair;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.mozilla.javascript.NativeContinuation;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;

@ApplicationScoped
public class AgamaPersistenceService {
    private static final String AGAMA_BASE = "ou=agama,o=jans";
    public static final String AGAMA_FLOWRUNS_BASE = "ou=runs,ou=agama,o=jans";
    public static final String AGAMA_FLOWS_BASE = "ou=flows,ou=agama,o=jans";
    @Inject
    private Logger logger;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    private ContinuationSerializer contSerializer;
    @Inject
    private FlowUtils flowUtils;
    @Inject
    private AppConfiguration appConfiguration;

    public FlowStatus getFlowStatus(String sessionId) throws IOException {
        try {
            this.logger.debug("Retrieving current flow's status");
            ProtoFlowRun fr = (ProtoFlowRun)((Object)this.entryManager.findEntries(AGAMA_FLOWRUNS_BASE, ProtoFlowRun.class, this.frEqFilter(sessionId), new String[]{"agFlowSt"}, 1).get(0));
            return fr.getStatus();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void persistFlowStatus(String sessionId, FlowStatus fst) throws IOException {
        try {
            ProtoFlowRun pfr = (ProtoFlowRun)((Object)this.entryManager.findEntries(AGAMA_FLOWRUNS_BASE, ProtoFlowRun.class, this.frEqFilter(sessionId), new String[]{"jansId"}, 1).get(0));
            this.logger.debug("Saving current flow's status");
            pfr.setStatus(fst);
            this.entryManager.merge((Object)pfr);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void createFlowRun(String id, FlowStatus fst, long expireAt) throws Exception {
        FlowRun fr = new FlowRun();
        fr.setBaseDn(String.format("%s=%s,%s", "jansId", id, AGAMA_FLOWRUNS_BASE));
        fr.setId(id);
        fr.setStatus(fst);
        fr.setDeletableAt(new Date(expireAt));
        this.logger.info("Creating flow run");
        this.entryManager.persist((Object)fr);
    }

    public boolean flowEnabled(String flowName) {
        try {
            Filter filth = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"agFlowQname", (Object)flowName), Filter.createEqualityFilter((String)"jansEnabled", (Object)true)});
            List results = this.entryManager.findEntries(AGAMA_FLOWS_BASE, ProtoFlow.class, filth, new String[]{"agFlowQname"}, 1);
            return results.size() == 1;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.warn("Flow '{}' does not seem to exist!", (Object)flowName);
            return false;
        }
    }

    public int getEffectiveFlowTimeout(String flowName, boolean nativeClient) {
        Flow fl = (Flow)this.entryManager.findEntries(AGAMA_FLOWS_BASE, Flow.class, Filter.createEqualityFilter((String)"agFlowQname", (Object)flowName), new String[]{"agFlowMeta"}, 1).get(0);
        int unauth = this.appConfiguration.getSessionIdUnauthenticatedUnusedLifetime();
        if (nativeClient) {
            unauth = Optional.ofNullable(this.appConfiguration.getAuthorizationChallengeSessionLifetimeInSeconds()).orElse(unauth);
        }
        Integer flowTimeout = fl.getMetadata().getTimeout();
        int timeout = Optional.ofNullable(flowTimeout).map(Integer::intValue).orElse(unauth);
        return Math.min(unauth, timeout);
    }

    public Flow getFlow(String flowName, boolean full) throws IOException {
        try {
            String[] attrs = null;
            if (!full) {
                attrs = new String[]{"agFlowQname", "agFlowMeta", "agFlowTrans"};
            }
            this.logger.debug("Retrieving {}info of flow '{}'", (Object)(full ? "" : "minimal "), (Object)flowName);
            List fls = this.entryManager.findEntries(AGAMA_FLOWS_BASE, Flow.class, Filter.createEqualityFilter((String)"agFlowQname", (Object)flowName), attrs, 1);
            if (fls.isEmpty()) {
                this.logger.warn("Flow '{}' does not exist!", (Object)flowName);
                return null;
            }
            return (Flow)fls.get(0);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Pair<Scriptable, NativeContinuation> getContinuation(String sessionId) throws IOException {
        FlowRun fr;
        try {
            fr = (FlowRun)((Object)this.entryManager.findEntries(AGAMA_FLOWRUNS_BASE, FlowRun.class, this.frEqFilter(sessionId), new String[]{"agFlowEncCont", "jansCustomMessage"}, 1).get(0));
        }
        catch (Exception e) {
            return null;
        }
        this.logger.debug("Restoring continuation data...");
        byte[] cont = Base64.getDecoder().decode(fr.getEncodedContinuation());
        if (!this.flowUtils.hash(cont).equals(fr.getHash())) {
            throw new IOException("Serialized continuation has been altered");
        }
        return this.contSerializer.restore(cont);
    }

    public void saveState(String sessionId, FlowStatus fst, NativeContinuation continuation, Scriptable scope) throws IOException {
        byte[] bytes = this.contSerializer.save(scope, continuation);
        this.logger.debug("Continuation serialized ({} bytes)", (Object)bytes.length);
        List results = this.entryManager.findEntries(AGAMA_FLOWRUNS_BASE, FlowRun.class, this.frEqFilter(sessionId), new String[]{"jansId", "exp"}, 1);
        FlowRun run = (FlowRun)((Object)results.get(0));
        run.setEncodedContinuation(new String(Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8));
        run.setHash(this.flowUtils.hash(bytes));
        run.setStatus(fst);
        this.logger.debug("Saving state of current flow run");
        this.entryManager.merge((Object)run);
    }

    public void finishFlow(String sessionId, FlowResult result) throws IOException {
        try {
            this.logger.debug("Retrieving flow run {}", (Object)sessionId);
            FlowRun run = (FlowRun)((Object)this.entryManager.findEntries(AGAMA_FLOWRUNS_BASE, FlowRun.class, this.frEqFilter(sessionId), new String[]{"jansId", "agFlowSt", "exp"}, 1).get(0));
            FlowStatus status = run.getStatus();
            status.setStartedAt(-1L);
            status.setResult(result);
            status.setQname(null);
            status.setJsonInput(null);
            status.setParentsMappings(null);
            status.setTemplatePath(null);
            status.setTemplateDataModel(null);
            status.setExternalRedirectUrl(null);
            status.setStartUrl(null);
            run.setEncodedContinuation(null);
            run.setHash(null);
            this.logger.info("Marking flow run as finished...");
            this.entryManager.merge((Object)run);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void terminateFlow(String sessionId) throws IOException {
        try {
            this.logger.info("Removing flow run...");
            this.entryManager.remove(AGAMA_FLOWRUNS_BASE, FlowRun.class, this.frEqFilter(sessionId), 1);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private Filter frEqFilter(String id) {
        return Filter.createEqualityFilter((String)"jansId", (Object)id);
    }
}

