/*
 * Decompiled with CFR 0.152.
 */
package io.jans.inbound.oauth2;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationErrorResponse;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import io.jans.inbound.oauth2.OAuthParams;
import io.jans.util.Pair;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CodeGrantUtil {
    private OAuthParams p;

    public CodeGrantUtil() {
    }

    public CodeGrantUtil(OAuthParams p) {
        this.p = p;
    }

    public static GeneralException exFromError(ErrorObject o) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object s = "" + o.getHTTPStatusCode();
        map.put("HTTP status", s);
        s = o.getCode();
        if (s != null) {
            map.put("error code", s);
        }
        if ((s = o.getDescription()) != null) {
            map.put("description", s);
        }
        s = ((Object)map).toString();
        return new GeneralException(((String)s).substring(1, ((String)s).length() - 1));
    }

    public Pair<String, String> makeAuthzRequest() throws URISyntaxException {
        URI authzEndpoint = new URI(this.p.getAuthzEndpoint());
        ClientID clientID = new ClientID(this.p.getClientId());
        URI callback = new URI(this.p.getRedirectUri());
        State state = new State();
        Scope scope = new Scope(this.p.getScopes().toArray(new String[0]));
        AuthorizationRequest.Builder builder = new AuthorizationRequest.Builder(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}), clientID).scope(scope).state(state).redirectionURI(callback).endpointURI(authzEndpoint);
        if (this.p.getCustParamsAuthReq() != null) {
            this.p.getCustParamsAuthReq().forEach((x$0, xva$1) -> builder.customParameter(x$0, new String[]{xva$1}));
        }
        return new Pair((Object)builder.build().toURI().toString(), (Object)state.getValue());
    }

    public String parseCode(Map<String, Object> urlParams, String state) throws URISyntaxException, GeneralException {
        URI callback = new URI(this.p.getRedirectUri());
        AuthorizationResponse response = AuthorizationResponse.parse((URI)callback, this.toMultivaluedMap(urlParams));
        if (!state.equals(response.getState().getValue())) {
            throw new GeneralException("Unexpected or tampered response");
        }
        if (!response.indicatesSuccess()) {
            AuthorizationErrorResponse errorResponse = response.toErrorResponse();
            throw CodeGrantUtil.exFromError(errorResponse.getErrorObject());
        }
        return response.toSuccessResponse().getAuthorizationCode().getValue();
    }

    public Map<String, Object> getTokenResponse(String authzCode) throws URISyntaxException, IOException, GeneralException {
        TokenRequest request;
        AuthorizationCode code = new AuthorizationCode(authzCode);
        AuthorizationCodeGrant codeGrant = new AuthorizationCodeGrant(code, new URI(this.p.getRedirectUri()));
        ClientID clientID = new ClientID(this.p.getClientId());
        ClientSecretBasic clientAuth = new ClientSecretBasic(clientID, new Secret(this.p.getClientSecret()));
        URI tokenEndpoint = new URI(this.p.getTokenEndpoint());
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        if (this.p.getCustParamsTokenReq() != null) {
            this.p.getCustParamsTokenReq().forEach((k, v) -> params.put((String)k, Collections.singletonList(v)));
        }
        if (this.p.isClientCredsInRequestBody()) {
            params.put("client_id", Collections.singletonList(this.p.getClientId()));
            params.put("client_secret", Collections.singletonList(this.p.getClientSecret()));
            request = new TokenRequest(tokenEndpoint, clientID, (AuthorizationGrant)codeGrant, null, null, null, params);
        } else {
            request = new TokenRequest(tokenEndpoint, (ClientAuthentication)clientAuth, (AuthorizationGrant)codeGrant, null, null, params);
        }
        HTTPRequest httpRequest = request.toHTTPRequest();
        httpRequest.setAccept("application/json");
        TokenResponse response = TokenResponse.parse((HTTPResponse)httpRequest.send());
        if (!response.indicatesSuccess()) {
            throw CodeGrantUtil.exFromError(response.toErrorResponse().getErrorObject());
        }
        return response.toSuccessResponse().toJSONObject();
    }

    private MultivaluedMap<String, String> toMultivaluedMap(Map<String, Object> map) {
        MultivaluedHashMap m = new MultivaluedHashMap();
        for (String key : map.keySet()) {
            Object val = map.get(key);
            if (val == null) continue;
            if (String.class.isInstance(val)) {
                m.putSingle((Object)key, (Object)val.toString());
                continue;
            }
            if (!Collection.class.isAssignableFrom(val.getClass())) continue;
            Collection col = (Collection)val;
            col.forEach(arg_0 -> CodeGrantUtil.lambda$toMultivaluedMap$2((MultivaluedMap)m, key, arg_0));
        }
        return m;
    }

    private static /* synthetic */ void lambda$toMultivaluedMap$2(MultivaluedMap m, String key, Object v) {
        m.add((Object)key, (Object)v.toString());
    }
}

