/*
 * Decompiled with CFR 0.152.
 */
package io.jans.inbound;

import io.jans.as.common.model.common.User;
import io.jans.as.common.service.common.UserService;
import io.jans.inbound.Provider;
import io.jans.orm.model.base.CustomObjectAttribute;
import io.jans.service.cdi.util.CdiUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityProcessor {
    private Provider provider;
    private static Logger logger = LoggerFactory.getLogger(IdentityProcessor.class);

    public IdentityProcessor() {
    }

    public IdentityProcessor(Provider provider) {
        this.provider = provider;
    }

    public Map<String, List<Object>> applyMapping(Map<String, Object> profile, Field f) throws IllegalAccessException {
        logger.debug("Retrieving value of field {}", (Object)f.getName());
        UnaryOperator op = (UnaryOperator)f.get(f.getDeclaringClass());
        logger.debug("Applying mapping to incoming profile");
        Map pr = (Map)op.apply(profile);
        HashMap<String, List<Object>> res = new HashMap<String, List<Object>>();
        for (String key : pr.keySet()) {
            Object value = pr.get(key);
            if (key == null || value == null) continue;
            List<Object> newValue = value.getClass().isArray() ? Arrays.asList(value) : (Collection.class.isInstance(value) ? new ArrayList((Collection)value) : Collections.singletonList(value));
            res.put(key, newValue);
        }
        return res;
    }

    public String process(Map<String, List<Object>> profile) {
        if (profile.isEmpty()) {
            throw new IllegalArgumentException("Empty profile data");
        }
        UserService userService = (UserService)CdiUtil.bean(UserService.class);
        logger.info("User provisioning started");
        User user = null;
        boolean update = true;
        String uid = profile.get("uid").get(0).toString();
        String email = Optional.ofNullable(profile.get("mail")).orElse(Collections.emptyList()).stream().findFirst().map(Object::toString).orElse(null);
        if (email != null && !email.contains("@")) {
            throw new IllegalArgumentException("Invalid e-mail " + email);
        }
        HashMap<String, List<Object>> profile2 = new HashMap<String, List<Object>>(profile);
        if (this.provider.isEmailLinkingSafe() && email != null && (user = userService.getUserByAttribute("mail", (Object)email)) != null) {
            logger.debug("Identity of incoming user is matched to existing {} by e-mail linking. Ignoring incoming uid {}", (Object)user.getUserId(), (Object)uid);
            uid = user.getUserId();
            profile2.remove("uid");
        }
        if (user == null) {
            logger.debug("Retrieving user identified by {}", (Object)uid);
            user = userService.getUser(uid, new String[0]);
            boolean bl = update = user != null;
        }
        if (update) {
            if (this.provider.isSkipProfileUpdate()) {
                logger.info("Skipping profile update");
            } else {
                logger.info("Updating user {}", (Object)uid);
                user.setCustomAttributes(this.attributesForUpdate(user.getCustomAttributes(), profile2, this.provider.isCumulativeUpdate()));
            }
            Optional.ofNullable(user.getAttributeValues("jansExtUid")).map(l -> l.toArray(new String[0])).ifPresent(arg_0 -> ((User)user).setExternalUid(arg_0));
            userService.updateUser(user);
        } else {
            logger.info("Adding user {}", (Object)uid);
            user = new User();
            user.setCustomAttributes(this.attributesForAdd(profile));
            userService.addUser(user, true);
        }
        return uid;
    }

    private List<CustomObjectAttribute> attributesForUpdate(List<CustomObjectAttribute> customAttributes, Map<String, List<Object>> profile, boolean cumulative) {
        ArrayList<CustomObjectAttribute> customAttrs = new ArrayList<CustomObjectAttribute>(customAttributes);
        for (CustomObjectAttribute coa : customAttrs) {
            String attrName = coa.getName();
            List<Object> newValues = profile.get(attrName);
            if (newValues == null) continue;
            ArrayList values = new ArrayList(cumulative ? coa.getValues() : Collections.emptyList());
            newValues.stream().filter(nv -> !values.contains(nv)).forEach(values::add);
            profile.remove(attrName);
            coa.setValues(values);
        }
        profile.forEach((k, v) -> {
            CustomObjectAttribute coa = new CustomObjectAttribute(k);
            coa.setValues(v);
            customAttrs.add(coa);
        });
        logger.trace("Resulting list of attributes:\n{}", (Object)((Object)customAttrs).toString());
        return customAttrs;
    }

    private List<CustomObjectAttribute> attributesForAdd(Map<String, List<Object>> profile) {
        ArrayList<CustomObjectAttribute> attrs = new ArrayList<CustomObjectAttribute>();
        profile.forEach((k, v) -> {
            CustomObjectAttribute coa = new CustomObjectAttribute(k);
            coa.setValues(v);
            attrs.add(coa);
        });
        return attrs;
    }
}

