/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EngineConfig {
    private boolean enabled;
    private String rootDir;
    private String templatesPath = "/ftl";
    private String scriptsPath = "/scripts";
    private int maxItemsLoggedInCollections = 3;
    private Boolean disableTCHV;
    private String pageMismatchErrorPage;
    private String interruptionErrorPage;
    private String crashErrorPage;
    private String finishedFlowPage;
    private Map<String, String> startEndUrlMapping;
    private Map<String, List<String>> serializeRules;
    private Map<String, String> defaultResponseHeaders = Map.of("Cache-Control", "max-age=0, no-store");

    public String getJsonErrorPage(String page) {
        return "json_" + page;
    }

    @JsonIgnore
    public String getJsonFinishedFlowPage() {
        return "json_" + this.finishedFlowPage;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }

    public String getTemplatesPath() {
        return this.templatesPath;
    }

    public void setTemplatesPath(String templatesPath) {
        this.templatesPath = templatesPath;
    }

    public String getScriptsPath() {
        return this.scriptsPath;
    }

    public void setScriptsPath(String scriptsPath) {
        this.scriptsPath = scriptsPath;
    }

    public String getInterruptionErrorPage() {
        return this.interruptionErrorPage;
    }

    public void setInterruptionErrorPage(String interruptionErrorPage) {
        this.interruptionErrorPage = interruptionErrorPage;
    }

    public int getMaxItemsLoggedInCollections() {
        return this.maxItemsLoggedInCollections;
    }

    public void setMaxItemsLoggedInCollections(int maxItemsLoggedInCollections) {
        this.maxItemsLoggedInCollections = maxItemsLoggedInCollections;
    }

    public Boolean getDisableTCHV() {
        return this.disableTCHV;
    }

    public void setDisableTCHV(Boolean disableTCHV) {
        this.disableTCHV = disableTCHV;
    }

    public String getCrashErrorPage() {
        return this.crashErrorPage;
    }

    public void setCrashErrorPage(String crashErrorPage) {
        this.crashErrorPage = crashErrorPage;
    }

    public String getPageMismatchErrorPage() {
        return this.pageMismatchErrorPage;
    }

    public void setPageMismatchErrorPage(String pageMismatchErrorPage) {
        this.pageMismatchErrorPage = pageMismatchErrorPage;
    }

    public String getFinishedFlowPage() {
        return this.finishedFlowPage;
    }

    public void setFinishedFlowPage(String finishedFlowPage) {
        this.finishedFlowPage = finishedFlowPage;
    }

    public Map<String, String> getDefaultResponseHeaders() {
        return this.defaultResponseHeaders;
    }

    public void setDefaultResponseHeaders(Map<String, String> defaultResponseHeaders) {
        this.defaultResponseHeaders = defaultResponseHeaders;
    }

    public Map<String, String> getStartEndUrlMapping() {
        return this.startEndUrlMapping;
    }

    public void setStartEndUrlMapping(Map<String, String> startEndUrlMapping) {
        this.startEndUrlMapping = startEndUrlMapping;
    }

    public Map<String, List<String>> getSerializeRules() {
        return this.serializeRules;
    }

    public void setSerializeRules(Map<String, List<String>> serializeRules) {
        this.serializeRules = serializeRules;
    }
}

