/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.dsl;

import freemarker.ext.dom.NodeModel;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import io.jans.agama.antlr.AuthnFlowLexer;
import io.jans.agama.antlr.AuthnFlowParser;
import io.jans.agama.dsl.TranspilationResult;
import io.jans.agama.dsl.TranspilerException;
import io.jans.agama.dsl.Visitor;
import io.jans.agama.dsl.error.RecognitionErrorListener;
import io.jans.agama.dsl.error.SyntaxException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.sapling.SaplingDocument;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class Transpiler {
    public static final String UTIL_SCRIPT_NAME = "util.js";
    public static final String UTIL_SCRIPT_CONTENTS;
    private static final String FTL_LOCATION = "JSGenerator.ftl";
    private static final ClassLoader CLS_LOADER;
    private static final Configuration FM_CONFIG;
    private final Logger logger = LoggerFactory.getLogger(Transpiler.class);
    private String flowId;
    private String fanny;
    private Processor processor;
    private XPathCompiler xpathCompiler;
    private Template jsGenerator;

    public Transpiler(String flowQName) throws TranspilerException {
        if (flowQName == null) {
            throw new TranspilerException("Qualified name cannot be null", new NullPointerException());
        }
        this.flowId = flowQName;
        this.fanny = "_" + flowQName.replaceAll("\\.", "_");
        this.processor = new Processor(false);
        this.xpathCompiler = this.processor.newXPathCompiler();
        this.xpathCompiler.setCaching(true);
        try {
            this.jsGenerator = FM_CONFIG.getTemplate(FTL_LOCATION);
        }
        catch (Exception e) {
            throw new TranspilerException("Template loading failed", e);
        }
    }

    private String getFanny() {
        return this.fanny;
    }

    private AuthnFlowParser.FlowContext getFlowContext(String DSLCode) throws SyntaxException, TranspilerException {
        ByteArrayInputStream is = new ByteArrayInputStream(DSLCode.getBytes(StandardCharsets.UTF_8));
        CharStream input = null;
        try {
            this.logger.debug("Creating ANTLR CharStream from DSL code");
            input = CharStreams.fromStream((InputStream)is);
        }
        catch (IOException ioe) {
            throw new TranspilerException(ioe.getMessage(), ioe);
        }
        AuthnFlowLexer lexer = new AuthnFlowLexer(input);
        RecognitionErrorListener lexerErrListener = new RecognitionErrorListener();
        lexer.addErrorListener((ANTLRErrorListener)lexerErrListener);
        this.logger.debug("Lexer for grammar '{}' initialized", (Object)lexer.getGrammarFileName());
        this.logger.debug("Creating parser");
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        AuthnFlowParser parser = new AuthnFlowParser((TokenStream)tokens);
        RecognitionErrorListener parserErrListener = new RecognitionErrorListener();
        parser.addErrorListener((ANTLRErrorListener)parserErrListener);
        try {
            AuthnFlowParser.FlowContext flowContext = parser.flow();
            SyntaxException syntaxException = Stream.of(lexerErrListener, parserErrListener).map(RecognitionErrorListener::getError).filter(Objects::nonNull).findFirst().orElse(null);
            if (syntaxException != null) {
                throw syntaxException;
            }
            if (!lexer._hitEOF) {
                throw new SyntaxException("Unable to process the input code thoroughly", lexer.getText(), lexer.getLine(), lexer.getCharPositionInLine());
            }
            return flowContext;
        }
        catch (RecognitionException re) {
            Token offender = re.getOffendingToken();
            throw new SyntaxException(re.getMessage(), offender.getText(), offender.getLine(), offender.getCharPositionInLine());
        }
    }

    public XdmNode asXML(String DSLCode) throws SyntaxException, TranspilerException, SaxonApiException {
        AuthnFlowParser.FlowContext flowContext = this.getFlowContext(DSLCode);
        this.validateName(flowContext);
        this.logger.debug("Traversing parse tree");
        SaplingDocument document = Visitor.document((ParseTree)flowContext, 0, Map.of("fqname", this.flowId, "fun", this.fanny));
        this.applyValidations(document);
        return document.toXdmNode(this.processor);
    }

    public List<String> getInputs(XdmNode node) throws SaxonApiException {
        return this.xpathCompiler.evaluate("/flow/header/inputs/short_var/text()", (XdmItem)node).stream().map(XdmItem::getStringValue).collect(Collectors.toList());
    }

    public Integer getTimeout(XdmNode node) throws SaxonApiException {
        return Optional.ofNullable(this.xpathCompiler.evaluateSingle("/flow/header/timeout/UINT/text()", (XdmItem)node)).map(XdmItem::getStringValue).map(Integer::valueOf).orElse(null);
    }

    public String generateJS(XdmNode node) throws TranspilerException {
        try {
            StringWriter sw = new StringWriter();
            NodeModel model = NodeModel.wrap((Node)NodeOverNodeInfo.wrap((NodeInfo)node.getUnderlyingNode()));
            this.jsGenerator.process((Object)model, (Writer)sw);
            return sw.toString();
        }
        catch (TemplateException | IOException e) {
            throw new TranspilerException("Transformation failed", e);
        }
    }

    private void applyValidations(SaplingDocument doc) throws TranspilerException {
        try {
            XdmNode node = doc.toXdmNode(this.processor);
            this.checkAutoInvocations(node);
            this.checkInputsUniqueness(node);
        }
        catch (SaxonApiException se) {
            throw new TranspilerException("Validation failed", se);
        }
    }

    private void validateName(AuthnFlowParser.FlowContext flowContext) throws TranspilerException {
        String qname = flowContext.header().qname().getText();
        if (!this.flowId.equals(qname)) {
            throw new TranspilerException("Qualified name mismatch: " + this.flowId + " vs. " + qname);
        }
    }

    private void checkAutoInvocations(XdmNode node) throws TranspilerException, SaxonApiException {
        Set invocations = this.xpathCompiler.evaluate("//flow_call/qname/text()", (XdmItem)node).stream().map(XdmItem::getStringValue).collect(Collectors.toSet());
        if (invocations.contains(this.flowId)) {
            throw new TranspilerException("A flow must not trigger an instance of itself");
        }
    }

    private void checkInputsUniqueness(XdmNode node) throws TranspilerException, SaxonApiException {
        List<String> inputs = this.getInputs(node);
        Set inputsSet = inputs.stream().collect(Collectors.toSet());
        String configVar = Optional.ofNullable(this.xpathCompiler.evaluateSingle("/flow/header/configs/short_var/text()", (XdmItem)node)).map(XdmItem::getStringValue).orElse(null);
        if (inputsSet.size() < inputs.size()) {
            throw new TranspilerException("One or more input variable names are duplicated");
        }
        if (configVar != null && inputsSet.contains(configVar)) {
            throw new TranspilerException("Configuration variable '" + configVar + "' cannot be used as an input variable");
        }
    }

    private void logXml(XdmNode node) {
        this.logger.debug("\n{}", (Object)node.toString());
    }

    private void generateFromXml(String fileName, OutputStream out) throws Exception {
        NodeModel model = NodeModel.parse((File)Paths.get(fileName, new String[0]).toFile());
        this.jsGenerator.process((Object)model, (Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    public static TranspilationResult transpile(String flowQname, String source) throws TranspilerException, SyntaxException {
        Transpiler tr = new Transpiler(flowQname);
        try {
            XdmNode doc = tr.asXML(source);
            TranspilationResult result = new TranspilationResult();
            result.setFuncName(tr.getFanny());
            result.setCode(tr.generateJS(doc));
            result.setInputs(tr.getInputs(doc));
            result.setTimeout(tr.getTimeout(doc));
            return result;
        }
        catch (SaxonApiException e) {
            throw new TranspilerException(e.getMessage(), e);
        }
    }

    public static void runSyntaxCheck(String flowQname, String source) throws SyntaxException, TranspilerException {
        Transpiler tr = new Transpiler(flowQname);
        tr.validateName(tr.getFlowContext(source));
    }

    public static void runSyntaxCheck(String source) throws SyntaxException, TranspilerException {
        Transpiler tr = new Transpiler("");
        tr.getFlowContext(source);
    }

    public static void main(String ... args) throws Exception {
        int len = args.length;
        if (len != 2) {
            System.err.println("Expecting 2 params: input file path and flow ID");
            return;
        }
        Transpiler tr = new Transpiler(args[1]);
        String dslCode = new String(Files.readAllBytes(Paths.get(args[0], new String[0])), StandardCharsets.UTF_8);
        XdmNode doc = tr.asXML(dslCode);
        tr.logXml(doc);
        System.out.println("\nInputs: " + tr.getInputs(doc));
        System.out.println("\nTimeout: " + tr.getTimeout(doc));
        System.out.println("\n" + tr.generateJS(doc));
    }

    static {
        CLS_LOADER = Transpiler.class.getClassLoader();
        try (InputStreamReader r = new InputStreamReader(CLS_LOADER.getResourceAsStream(UTIL_SCRIPT_NAME), StandardCharsets.UTF_8);
             StringWriter sw = new StringWriter();){
            r.transferTo(sw);
            UTIL_SCRIPT_CONTENTS = sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read utility script", e);
        }
        FM_CONFIG = new Configuration(Configuration.VERSION_2_3_32);
        FM_CONFIG.setClassLoaderForTemplateLoading(CLS_LOADER, "/");
        FM_CONFIG.setDefaultEncoding(StandardCharsets.UTF_8.toString());
        FM_CONFIG.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        FM_CONFIG.setLogTemplateExceptions(false);
        FM_CONFIG.setWrapUncheckedExceptions(true);
        FM_CONFIG.setFallbackOnNullLoopVariable(false);
    }
}

