/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.dsl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VarsTransformer {
    private static final String EVAL_SYMBOL = "$";
    private static final Logger logger = LoggerFactory.getLogger(VarsTransformer.class);
    private static final Set<String> JS_KEYWORDS;
    private static final String STRING_INDEX_FUNC = "_sc";
    private static final String INT_INDEX_FUNC = "_ic";

    public static String correctedVariable(String variable) {
        Object identifier;
        int dotIndex = variable.indexOf(".");
        int rbIndex = variable.indexOf("[");
        int index = dotIndex != -1 ? (rbIndex != -1 ? Math.min(dotIndex, rbIndex) : dotIndex) : rbIndex;
        Object object = identifier = index == -1 ? variable : variable.substring(0, index);
        if (JS_KEYWORDS.contains(identifier)) {
            logger.trace("Renaming variable {}", (Object)variable);
            identifier = "_" + (String)identifier;
        }
        return index == -1 ? identifier : (String)identifier + variable.substring(index);
    }

    public static String convertToBracketNotation(String str) {
        return VarsTransformer.processDotEvalAccessors(VarsTransformer.processStringAccessors(VarsTransformer.processExistingBrackets(str)));
    }

    private static String processDotEvalAccessors(String str) {
        String subs;
        StringBuilder sb = new StringBuilder();
        int symlen = EVAL_SYMBOL.length();
        int j = 0;
        int i = str.indexOf(".$");
        if (i == -1) {
            return str;
        }
        do {
            sb.append(str.substring(j, i));
            int dot = str.indexOf(".", i + 1 + symlen);
            int brack = str.indexOf("[", i + 1 + symlen);
            j = dot == -1 ? (brack == -1 ? str.length() : brack) : (brack == -1 ? dot : Math.min(dot, brack));
            subs = str.substring(i + 1 + symlen, j);
            sb.append(String.format("[%s(%s, \"%s\")]", STRING_INDEX_FUNC, subs, subs));
        } while ((i = str.indexOf(".$", j)) != -1);
        sb.append(str.substring(j));
        subs = sb.toString();
        logger.trace("processDotEvalAccessors: {} converted to {}", (Object)str, (Object)subs);
        return subs;
    }

    private static String processStringAccessors(String str) {
        String subs;
        StringBuilder sb = new StringBuilder();
        int j = -1;
        int i = str.indexOf(".\"");
        if (i == -1) {
            return str;
        }
        do {
            sb.append(str.substring(j + 1, i));
            j = str.indexOf("\"", i + 2);
            subs = str.substring(i + 1, j + 1);
            sb.append(String.format("[%s(%s, null)]", STRING_INDEX_FUNC, subs));
        } while ((i = str.indexOf(".\"", j + 1)) != -1);
        sb.append(str.substring(j + 1));
        subs = sb.toString();
        logger.trace("processStringAccessors: {} converted to {}", (Object)str, (Object)subs);
        return subs;
    }

    private static String processExistingBrackets(String str) {
        String subs;
        StringBuilder sb = new StringBuilder();
        int j = 0;
        int i = str.indexOf("[");
        if (i == -1) {
            return str;
        }
        do {
            sb.append(str.substring(j, i + 1));
            j = str.indexOf("]", i + 1);
            subs = str.substring(i + 1, j);
            sb.append(String.format("%s(%s, \"%s\")", INT_INDEX_FUNC, subs, subs));
        } while ((i = str.indexOf("[", j + 1)) != -1);
        sb.append(str.substring(j));
        subs = sb.toString();
        logger.trace("processExistingBrackets: {} converted to {}", (Object)str, (Object)subs);
        return subs;
    }

    static {
        String[] javascriptKeywords = new String[]{"break", "case", "catch", "class", "const", "continue", "debugger", "default", "delete", "do", "else", "export", "extends", "finally", "for", "function", "if", "import", "in", "instanceof", "new", "return", "super", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "yield", "enum", "await", "let", "Packages", "java", "Infinity", "NaN", "undefined", "globalThis", "Object", "Function", "Boolean", "Symbol", "Error", "AggregateError", "EvalError", "InternalError", "RangeError", "ReferenceError", "SyntaxError", "TypeError", "URIError", "Number", "BigInt", "Math", "Date", "String", "RegExp", "Array", "Int8Array", "Uint8Array", "Uint8ClampedArray", "Int16Array", "Uint16Array", "Int32Array", "Uint32Array", "Float32Array", "Float64Array", "BigInt64Array", "BigUint64Array", "Map", "Set", "WeakMap", "WeakSet", "ArrayBuffer", "SharedArrayBuffer", "Atomics", "DataView", "JSON", "Promise", "arguments"};
        JS_KEYWORDS = new HashSet<String>(Arrays.asList(javascriptKeywords));
    }
}

