/*
 * Decompiled with CFR 0.152.
 */
package io.jans.agama.dsl.error;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Optional;
import java.util.function.Function;

@JsonIgnoreProperties(value={"cause", "localizedMessage", "stackTrace", "suppressed"})
public class SyntaxException
extends Exception {
    private String error;
    private String symbol;
    private int line;
    private int column;

    public SyntaxException() {
    }

    public SyntaxException(String error, String symbol, int line, int column) {
        this.error = error;
        this.symbol = symbol;
        this.line = line;
        this.column = column;
    }

    @Override
    public String getMessage() {
        Object msg = "Syntax error: ";
        msg = (String)msg + Optional.ofNullable(this.error).map(Function.identity()).orElse("");
        msg = (String)msg + Optional.ofNullable(this.symbol).map(s -> String.format("\nSymbol: %s", s)).orElse("");
        msg = (String)msg + String.format("\nLine: %d", this.line);
        msg = (String)msg + String.format("\nColumn: %d", this.column + 1);
        return msg;
    }

    public String getError() {
        return this.error;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }
}

