/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.misc;

import io.jans.casa.misc.Utils;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.ui.Executions;

public final class WebUtils {
    private static Logger LOG = LoggerFactory.getLogger(WebUtils.class);
    public static final String USER_PAGE_URL = "user.zul";
    public static final String ADMIN_PAGE_URL = "admin.zul";
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;

    private WebUtils() {
    }

    public static HttpServletRequest getServletRequest() {
        return (HttpServletRequest)Executions.getCurrent().getNativeRequest();
    }

    public static HttpServletResponse getServletResponse() {
        return (HttpServletResponse)Executions.getCurrent().getNativeResponse();
    }

    public static String getRequestHeader(String headerName) {
        return WebUtils.getServletRequest().getHeader(headerName);
    }

    public static void invalidateSession(HttpServletRequest request) {
        Optional.ofNullable(request.getSession(false)).ifPresent(HttpSession::invalidate);
    }

    public static String getRemoteIP() {
        String[] ips;
        String ip = WebUtils.getRequestHeader("X-Forwarded-For");
        ip = ip == null ? WebUtils.getServletRequest().getRemoteAddr() : (Utils.isNotEmpty(ips = ip.split(",\\s*")) ? ips[0] : null);
        return ip;
    }

    public static void execRedirect(String url) {
        WebUtils.execRedirect(url, true);
    }

    public static void execRedirect(String url, boolean voidUI) {
        try {
            HttpServletResponse response = WebUtils.getServletResponse();
            LOG.debug("Redirecting to URL={}", (Object)url);
            response.sendRedirect(response.encodeRedirectURL(url));
            if (voidUI) {
                Executions.getCurrent().setVoided(voidUI);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String getQueryParam(String param) {
        String[] values = Executions.getCurrent().getParameterValues(param);
        return Utils.isEmpty(values) ? null : values[0];
    }

    public static String validateImageUrl(String url) {
        String val = null;
        try {
            val = ImageIO.read(new URL(url)) == null ? null : url;
        }
        catch (Exception e) {
            LOG.warn("Error validating image url '{}'", (Object)url);
        }
        return val;
    }

    public static String getFullRequestURL() {
        HttpServletRequest req = WebUtils.getServletRequest();
        String query = req.getQueryString();
        StringBuffer sb = req.getRequestURL();
        if (query != null) {
            sb.append("?").append(query);
        }
        return sb.toString();
    }

    public static String getValueFromCookie(String cookieName) {
        try {
            Cookie[] cookies = ((HttpServletRequest)Executions.getCurrent().getNativeRequest()).getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals(cookieName)) continue;
                    LOG.info("Found cookie: '{}'", (Object)cookie.getValue());
                    return cookie.getValue();
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return "";
    }
}

