/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.ui;

import java.util.stream.Stream;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.util.Clients;

public final class UIUtils {
    public static final int FEEDBACK_DELAY_SUCC = 3000;
    public static final int FEEDBACK_DELAY_ERR = 5000;

    private UIUtils() {
    }

    public static void showMessageUI(boolean success) {
        UIUtils.showMessageUI(success, Labels.getLabel((String)(success ? "general.operation_completed" : "general.error.general")));
    }

    public static void showMessageUI(boolean success, String msg) {
        UIUtils.showMessageUI(success, msg, "middle_center");
    }

    public static void showMessageUI(boolean success, String msg, String position) {
        UIUtils.showMessageUI(success ? "info" : "error", msg);
    }

    public static void showMessageUI(String notificationType, String msg) {
        String type = Stream.of("error", "info", "warning").filter(t -> t.equals(notificationType)).findFirst().orElse("warning");
        Clients.response((AuResponse)new AuInvoke("showAlert", new Object[]{msg, type, type.equals("error") ? 5000 : 3000}));
    }
}

