/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.misc;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.casa.core.model.CustomScript;
import io.jans.model.SimpleCustomProperty;
import io.jans.util.properties.FileConfiguration;
import io.jans.util.security.StringEncrypter;
import jakarta.enterprise.inject.spi.CDI;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.tika.Tika;
import org.apache.tika.io.TikaInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static Logger LOG = LoggerFactory.getLogger(Utils.class);
    private static ObjectMapper MAPPER = new ObjectMapper();
    private static Tika tika = new Tika();
    private static final String SALT_FILE_LOCATION = "/etc/jans/conf/salt";

    private Utils() {
    }

    public static boolean onWindows() {
        return System.getProperty("os.name").toLowerCase().matches(".*win.*");
    }

    public static boolean isEmpty(String string) {
        return !Utils.isNotEmpty(string);
    }

    public static boolean isNotEmpty(String string) {
        return Optional.ofNullable(string).map(String::length).flatMap(i -> i > 0 ? Optional.of(i) : Optional.empty()).isPresent();
    }

    public static <T> boolean isEmpty(T[] array) {
        return !Utils.isNotEmpty(array);
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return Optional.ofNullable(array).map(arr -> ((Object[])arr).length).flatMap(i -> i > 0 ? Optional.of(i) : Optional.empty()).isPresent();
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return !Utils.isNotEmpty(collection);
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return Optional.ofNullable(collection).map(Collection::size).flatMap(i -> i > 0 ? Optional.of(i) : Optional.empty()).isPresent();
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return !Utils.isNotEmpty(map);
    }

    public static <K, V> boolean isNotEmpty(Map<K, V> map) {
        return Optional.ofNullable(map).map(Map::size).flatMap(i -> i > 0 ? Optional.of(i) : Optional.empty()).isPresent();
    }

    public static boolean isJarFile(Path path) {
        return path.toString().toLowerCase().endsWith(".jar") && Files.isRegularFile(path, new LinkOption[0]);
    }

    public static boolean isClassFile(Path path) {
        return path.toString().endsWith(".class") && Files.isRegularFile(path, new LinkOption[0]);
    }

    public static <T> T managedBean(Class<T> clazz) {
        return (T)CDI.current().select(clazz, new Annotation[0]).get();
    }

    public static String jsonFromObject(Object obj) {
        String json;
        try {
            json = MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            json = "{}";
        }
        return json;
    }

    public static String getImageDataUriEncoding(byte[] bytes, String hintName) {
        String encodedImg;
        String mime;
        block11: {
            mime = null;
            encodedImg = Base64.getEncoder().encodeToString(bytes);
            try (TikaInputStream tis = TikaInputStream.get((byte[])bytes);){
                mime = tika.detect((InputStream)tis, hintName);
                if (mime.equals("application/octet-stream") && hintName != null) {
                    LOG.trace("Cannot infer mime type of image using Tika");
                    mime = URLConnection.guessContentTypeFromName(hintName);
                }
            }
            catch (Exception e) {
                if (hintName == null) break block11;
                mime = URLConnection.guessContentTypeFromName(hintName);
            }
        }
        if (mime == null) {
            mime = "";
            LOG.trace("Cannot infer mime type of image");
        } else {
            LOG.trace("Using mime {}", (Object)mime);
        }
        return String.format("data:%s;base64,%s", mime, encodedImg);
    }

    public static Object cloneObject(Object obj) {
        Object result = null;
        try {
            result = MAPPER.readValue(MAPPER.writeValueAsString(obj), obj.getClass());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static <T> List<T> listfromArray(T[] array) {
        if (Utils.isEmpty(array)) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    public static <T> T[] arrayFromValue(Class<T> cls, T value) {
        Object[] arr = (Object[])Array.newInstance(cls, value == null ? 0 : 1);
        if (arr.length == 1) {
            arr[0] = value;
        }
        return arr;
    }

    public static <T> List<T> nonNullList(List<T> list) {
        return Optional.ofNullable(list).orElse(Collections.emptyList());
    }

    public static boolean hostAvailabilityCheck(SocketAddress address, int timeout) {
        boolean available = false;
        try (Socket socket = new Socket();){
            socket.connect(address, timeout);
            available = true;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return available;
    }

    public static boolean isValidUrl(String strUrl) {
        boolean valid = false;
        try {
            URL url = new URL(strUrl);
            valid = Utils.isNotEmpty(url.getHost());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!valid) {
            LOG.warn("Error validating url: {}", (Object)strUrl);
        }
        return valid;
    }

    public static <T> int firstTrue(List<T> list, Function<? super T, ? extends Boolean> map) {
        return list.stream().map(map).collect(Collectors.toList()).indexOf(true);
    }

    public static byte[] randomBytes(int keyLen) {
        byte[] bytes = new byte[keyLen];
        SecureRandom random = new SecureRandom();
        random.nextBytes(bytes);
        return bytes;
    }

    public static Map<String, String> scriptConfigPropertiesAsMap(CustomScript script) {
        return Utils.nonNullList(script.getConfigurationProperties()).stream().collect(Collectors.toMap(SimpleCustomProperty::getValue1, SimpleCustomProperty::getValue2));
    }

    public static Map<String, String> scriptModulePropertiesAsMap(CustomScript script) {
        return Utils.nonNullList(script.getModuleProperties()).stream().collect(Collectors.toMap(SimpleCustomProperty::getValue1, SimpleCustomProperty::getValue2));
    }

    public static StringEncrypter stringEncrypter(String saltFile) throws StringEncrypter.EncryptionException {
        String salt = new FileConfiguration(saltFile).getProperties().getProperty("encodeSalt");
        return StringEncrypter.instance((String)salt);
    }

    public static StringEncrypter stringEncrypter() throws StringEncrypter.EncryptionException {
        return Utils.stringEncrypter(SALT_FILE_LOCATION);
    }

    public static boolean urlAvailabilityCheck(URL siteURL) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)siteURL.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(3000);
        connection.connect();
        return connection.getResponseCode() == 200;
    }
}

