/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.acctlinking.vm;

import io.jans.casa.plugins.acctlinking.AccountsLinkingService;
import io.jans.casa.service.ISessionContext;
import io.jans.casa.ui.UIUtils;
import io.jans.inbound.Provider;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Messagebox;

public class AccountsLinkingVM {
    public static final String LINK_QUEUE = "social_queue";
    public static final String EVENT_NAME = "linked";
    public static final long ENROLL_TIME_MS = TimeUnit.MINUTES.toMillis(1L);
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @WireVariable
    private ISessionContext sessionContext;
    private AccountsLinkingService als = AccountsLinkingService.getInstance();
    private Map<String, Provider> providers;
    private Map<String, String> accounts;
    private String userId;
    private String pendingProvider;
    private long pendingLinkingExpiresAt;

    public Map<String, Provider> getProviders() {
        return this.providers;
    }

    public Map<String, String> getAccounts() {
        return this.accounts;
    }

    public String getPendingProvider() {
        return this.pendingProvider;
    }

    public boolean isUsePopup() {
        return this.als.usePopup();
    }

    @Init
    public void init() {
        try {
            this.logger.info("Refreshing list of identity providers");
            this.providers = this.als.getProviders(true);
            this.logger.info("{} identity providers found", (Object)this.providers.size());
            this.userId = this.sessionContext.getLoggedUser().getId();
            this.parseLinkedAccounts();
            if (this.providers.size() > 0) {
                EventQueues.lookup((String)LINK_QUEUE, (String)"session", (boolean)true).subscribe(event -> {
                    if (event.getName().equals(EVENT_NAME)) {
                        String data = Optional.ofNullable(event.getData()).map(Object::toString).orElse(null);
                        if (data != null) {
                            this.logger.info("Received link start event for {}", (Object)data);
                            this.pendingLinkingExpiresAt = System.currentTimeMillis() + ENROLL_TIME_MS;
                            this.pendingProvider = data;
                        } else {
                            this.logger.info("Received linked event");
                            this.cancel();
                            this.parseLinkedAccounts();
                        }
                        BindUtils.postNotifyChange((Object)this, (String[])new String[]{"accounts", "pendingProvider"});
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    @NotifyChange(value={"pendingProvider"})
    public void cancel() {
        this.pendingProvider = null;
    }

    @Command
    public void poll() {
        if (this.pendingProvider != null && this.pendingLinkingExpiresAt < System.currentTimeMillis()) {
            this.logger.info("Too much time elapsed for linking to finish");
            this.cancel();
            BindUtils.postNotifyChange((Object)this, (String)"pendingProvider");
        }
    }

    public void remove(String providerId, String extUid) {
        if (this.accounts.size() > 1 || this.als.hasPassword(this.userId)) {
            Provider p = this.providers.get(providerId);
            Messagebox.show((String)Labels.getLabel((String)"al.remove_hint"), null, (int)48, (String)"z-messagebox-icon z-messagebox-question", event -> {
                if ("onYes".equals(event.getName())) {
                    if (this.als.delink(this.userId, providerId, extUid)) {
                        this.parseLinkedAccounts();
                        UIUtils.showMessageUI((boolean)true, (String)Labels.getLabel((String)"al.removed_link", (Object[])new String[]{p.getDisplayName()}));
                        BindUtils.postNotifyChange((Object)this, (String)"accounts");
                    } else {
                        UIUtils.showMessageUI((boolean)false);
                    }
                }
            });
        } else {
            Messagebox.show((String)Labels.getLabel((String)"al.linking_pass_needed"), null, (int)1, (String)"z-messagebox-icon z-messagebox-information");
        }
    }

    private void parseLinkedAccounts() {
        this.logger.info("Parsing linked accounts for {}", (Object)this.userId);
        this.accounts = this.als.getAccounts(this.userId, this.providers.keySet());
    }
}

