/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.acctlinking;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import io.jans.casa.conf.OIDCClientSettings;
import io.jans.casa.core.model.IdentityPerson;
import io.jans.casa.misc.Utils;
import io.jans.casa.model.ApplicationConfiguration;
import io.jans.casa.plugins.acctlinking.conf.Config;
import io.jans.casa.service.IPersistenceService;
import io.jans.casa.service.settings.IPluginSettingsHandler;
import io.jans.casa.service.settings.IPluginSettingsHandlerFactory;
import io.jans.inbound.Provider;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountsLinkingService {
    public static final String CASA_AGAMA_FLOW = "io.jans.casa.authn.acctlinking";
    public static final String READ_SCOPE = "https://jans.io/oauth/config/agama.readonly";
    private static final String AGAMA_PRJ = "casa-account-linking";
    private static final String CONFIGS_ENDPOINT = "/jans-config-api/api/v1/agama-deployment/configs/casa-account-linking";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static AccountsLinkingService instance;
    private IPersistenceService ips;
    private IPluginSettingsHandler<Config> settingsHandler;
    private ObjectMapper mapper;
    private OIDCClientSettings clSettings;
    private String issuer;
    private String basicAuthnHeader;

    public static AccountsLinkingService getInstance(String pluginId) {
        if (instance == null && pluginId != null) {
            instance = new AccountsLinkingService(pluginId);
        }
        return instance;
    }

    public static AccountsLinkingService getInstance() {
        return instance;
    }

    public boolean usePopup() {
        return Optional.ofNullable((Config)this.settingsHandler.getSettings()).map(Config::isUsePopup).orElse(true);
    }

    public OIDCClientSettings getCasaClient() {
        return this.clSettings;
    }

    public Map<String, Provider> getProviders(boolean enabledOnly) throws Exception {
        HTTPRequest request = new HTTPRequest(HTTPRequest.Method.GET, new URL(this.issuer + CONFIGS_ENDPOINT));
        this.setTimeouts(request);
        request.setAuthorization(this.basicAuthnHeader);
        request.setAuthorization("Bearer " + this.getAToken());
        HTTPResponse r = request.send();
        r.ensureStatusCode(new int[]{200});
        Map madam = (Map)this.mapper.readValue(r.getBody(), (TypeReference)new TypeReference<Map<String, Map<String, Provider>>>(){});
        Map<String, Provider> madman = Optional.ofNullable(madam).map(m -> (Map)m.get(CASA_AGAMA_FLOW)).orElse(Collections.emptyMap());
        if (enabledOnly) {
            madman = madman.entrySet().stream().filter(e -> ((Provider)e.getValue()).isEnabled()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return madman;
    }

    public Map<String, String> getAccounts(String userId, Set<String> knownProviders) {
        HashMap<String, String> accts = new HashMap<String, String>();
        for (String extUid : this.getPerson(userId).getJansExtUid()) {
            String pref;
            int i = extUid.indexOf(":");
            if (i <= 0 || i >= extUid.length() - 1 || !knownProviders.contains(pref = extUid.substring(0, i))) continue;
            accts.put(pref, extUid.substring(i + 1));
        }
        return accts;
    }

    public boolean delink(String userId, String providerId, String extUid) {
        try {
            IdentityPerson p = this.getPerson(userId);
            ArrayList extUids = new ArrayList(p.getJansExtUid());
            extUids.remove(this.computeExtUid(providerId, extUid));
            p.setJansExtUid(extUids);
            this.ips.modify((Object)p);
            return true;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean hasPassword(String id) {
        return this.getPerson(id).hasPassword();
    }

    private IdentityPerson getPerson(String id) {
        return (IdentityPerson)this.ips.get(IdentityPerson.class, this.ips.getPersonDn(id));
    }

    private String computeExtUid(String providerId, String id) {
        return providerId + ":" + id;
    }

    private AccountsLinkingService(String pluginId) {
        this.logger.info("Initializing AccountsLinkingService");
        this.settingsHandler = ((IPluginSettingsHandlerFactory)Utils.managedBean(IPluginSettingsHandlerFactory.class)).getHandler(pluginId, Config.class);
        this.mapper = new ObjectMapper();
        this.ips = (IPersistenceService)Utils.managedBean(IPersistenceService.class);
        this.issuer = this.ips.getIssuerUrl();
        this.logger.debug("Issuer is {}", (Object)this.issuer);
        this.clSettings = ((ApplicationConfiguration)this.ips.get(ApplicationConfiguration.class, "ou=casa,ou=configuration,o=jans")).getSettings().getOidcSettings().getClient();
        Object authz = this.clSettings.getClientId() + ":" + this.clSettings.getClientSecret();
        authz = new String(Base64.getEncoder().encode(((String)authz).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        this.basicAuthnHeader = "Basic " + (String)authz;
    }

    private String getAToken() throws IOException {
        StringJoiner joiner = new StringJoiner("&");
        Map.of("grant_type", "client_credentials", "scope", URLEncoder.encode(READ_SCOPE, StandardCharsets.UTF_8)).forEach((k, v) -> joiner.add(k + "=" + v));
        this.logger.info("Calling token endpoint");
        HTTPRequest request = new HTTPRequest(HTTPRequest.Method.POST, new URL(this.issuer + "/jans-auth/restv1/token"));
        this.setTimeouts(request);
        request.setQuery(joiner.toString());
        request.setAuthorization(this.basicAuthnHeader);
        try {
            JSONObject jobj = request.send().getContentAsJSONObject();
            this.logger.info("Successful call");
            return jobj.get("access_token").toString();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void setTimeouts(HTTPRequest request) {
        request.setConnectTimeout(3500);
        request.setReadTimeout(3500);
    }
}

