/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.acctlinking.vm;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.as.model.util.Base64Util;
import io.jans.casa.conf.OIDCClientSettings;
import io.jans.casa.misc.Utils;
import io.jans.casa.misc.WebUtils;
import io.jans.casa.plugins.acctlinking.AccountsLinkingService;
import io.jans.casa.plugins.acctlinking.vm.AccountsLinkingVM;
import io.jans.casa.service.IPersistenceService;
import io.jans.casa.service.ISessionContext;
import io.jans.inbound.oauth2.CodeGrantUtil;
import io.jans.inbound.oauth2.OAuthParams;
import io.jans.service.cache.CacheInterface;
import io.jans.util.Pair;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.QueryParam;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zk.ui.select.annotation.WireVariable;

public class SiteRedirectVM {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String STATE_ATTR = "st";
    @WireVariable
    private ISessionContext sessionContext;
    private CacheInterface cache;
    private AccountsLinkingService als = AccountsLinkingService.getInstance();
    private ObjectMapper mapper = new ObjectMapper();
    private String serverUrl = ((IPersistenceService)Utils.managedBean(IPersistenceService.class)).getIssuerUrl();
    private String userName;
    private String text;
    private String title;

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public SiteRedirectVM() {
        this.cache = (CacheInterface)Utils.managedBean(CacheInterface.class);
    }

    @Init
    public void init(@QueryParam(value="provider") String provider) {
        try {
            this.logger.debug("Initializing ViewModel");
            this.userName = this.sessionContext.getLoggedUser().getUserName();
            this.title = Labels.getLabel((String)"general.error.general");
            String currentUrl = WebUtils.getServletRequest().getRequestURL().toString();
            CodeGrantUtil cgu = new CodeGrantUtil(this.makeOAuthParams(this.als.getCasaClient(), provider, currentUrl));
            if (Utils.isNotEmpty((String)provider)) {
                this.text = Labels.getLabel((String)"al.link_redirect_failed", (Object[])new String[]{provider});
                String url = this.getAuthzRequestRedirectUrl(cgu);
                EventQueues.lookup((String)"social_queue", (String)"session", (boolean)true).publish(new Event("linked", null, (Object)provider));
                WebUtils.execRedirect((String)url, (boolean)false);
            } else {
                String state = Optional.ofNullable(Sessions.getCurrent().getAttribute(STATE_ATTR)).map(Object::toString).orElse(null);
                if (state == null) {
                    return;
                }
                Map<String, Object> mama = WebUtils.getServletRequest().getParameterMap().entrySet().stream().map(entry -> {
                    String[] val = (String[])entry.getValue();
                    List values = val == null || val.length == 0 ? Collections.emptyList() : Arrays.asList(val);
                    return new AbstractMap.SimpleEntry((String)entry.getKey(), values);
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                String code = cgu.parseCode(mama, state);
                this.logger.info("Got an authz code at callback URL");
                cgu.getTokenResponse(code);
                this.logger.info("Notifying linking page...");
                EventQueues.lookup((String)"social_queue", (String)"session", (boolean)true).publish(new Event("linked", null, null));
                this.title = Labels.getLabel((String)"al.linking_result.success");
                this.text = Labels.getLabel((String)"al.linking_result.success_close");
            }
        }
        catch (Exception e) {
            this.text = e.getMessage();
            this.logger.error(this.text, (Throwable)e);
        }
    }

    private String getAuthzRequestRedirectUrl(CodeGrantUtil cgu) throws URISyntaxException {
        this.logger.info("Building an agama authentication request");
        Pair<String, String> pair = cgu.makeAuthzRequest();
        Sessions.getCurrent().setAttribute(STATE_ATTR, pair.getSecond());
        return (String)pair.getFirst();
    }

    private OAuthParams makeOAuthParams(OIDCClientSettings cl, String provider, String redirectUri) {
        OAuthParams p = new OAuthParams();
        p.setAuthzEndpoint(this.serverUrl + "/jans-auth/restv1/authorize");
        p.setTokenEndpoint(this.serverUrl + "/jans-auth/restv1/token");
        p.setClientId(cl.getClientId());
        p.setClientSecret(cl.getClientSecret());
        p.setScopes(Collections.singletonList("openid"));
        p.setRedirectUri(redirectUri);
        HashMap<String, String> custMap = new HashMap<String, String>();
        if (provider != null) {
            custMap.put("acr_values", "agama_" + "io.jans.casa.authn.acctlinking" + "-" + this.buildFlowParams(provider));
        }
        custMap.put("prompt", "login");
        p.setCustParamsAuthReq(custMap);
        return p;
    }

    private String buildFlowParams(String provider) {
        String key = "" + Math.random();
        int sec = Long.valueOf(AccountsLinkingVM.ENROLL_TIME_MS).intValue() / 1000;
        this.logger.debug("Writing uid ref to cache");
        this.cache.put(2 * sec, key, (Object)this.userName);
        String s = null;
        try {
            s = this.mapper.writeValueAsString(Map.of("providerId", provider, "uidRef", key));
            s = Base64Util.base64urlencode((byte[])s.getBytes(StandardCharsets.UTF_8));
        }
        catch (JsonProcessingException e) {
            this.logger.error(e.getMessage());
        }
        return s;
    }
}

