/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.consent;

import io.jans.casa.core.model.Client;
import io.jans.casa.core.model.Scope;
import io.jans.casa.core.pojo.User;
import io.jans.casa.plugins.consent.service.ClientAuthorizationsService;
import io.jans.casa.service.ISessionContext;
import io.jans.casa.ui.UIUtils;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Messagebox;

public class AuthorizedClientsVM {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @WireVariable
    private ISessionContext sessionContext;
    private User user;
    private ClientAuthorizationsService caService;
    private Map<Client, Set<Scope>> clients;

    public Map<Client, Set<Scope>> getClients() {
        return this.clients;
    }

    @Init
    public void init() {
        this.logger.info("Authorized Clients ViewModel inited");
        this.user = this.sessionContext.getLoggedUser();
        this.caService = new ClientAuthorizationsService();
        this.reloadClients();
    }

    public String getContactEmailsAsCSV(Client client) {
        return client.getContacts().stream().collect(Collectors.joining(", "));
    }

    public void revokeAll() {
        Messagebox.show((String)Labels.getLabel((String)"clients.authorized.remove_hint_all"), null, (int)48, (String)"z-messagebox-icon z-messagebox-question", event -> {
            if ("onYes".equals(event.getName())) {
                this.logger.info("Removing all client authorizations for user {}", (Object)this.user.getId());
                this.clients.keySet().forEach(client -> this.caService.removeClientAuthorizations(this.user.getId(), this.user.getUserName(), client.getInum()));
                this.reloadClients();
                if (this.clients.size() == 0) {
                    UIUtils.showMessageUI((boolean)true);
                } else {
                    String detail = Labels.getLabel((String)"clients.authorized.notall_removed");
                    UIUtils.showMessageUI((boolean)false, (String)Labels.getLabel((String)"general.error.detailed", (Object[])new String[]{detail}));
                }
                BindUtils.postNotifyChange((Object)this, (String)"clients");
            }
        });
    }

    public void revoke(String clientId, String clientName) {
        Messagebox.show((String)Labels.getLabel((String)"clients.authorized.remove_hint"), null, (int)48, (String)"z-messagebox-icon z-messagebox-question", event -> {
            if ("onYes".equals(event.getName())) {
                int currSize = this.clients.size();
                this.caService.removeClientAuthorizations(this.user.getId(), this.user.getUserName(), clientId);
                this.reloadClients();
                if (currSize - 1 == this.clients.size()) {
                    UIUtils.showMessageUI((boolean)true);
                } else {
                    UIUtils.showMessageUI((boolean)false, (String)Labels.getLabel((String)"clients.authorized.remove_error", (Object[])new String[]{clientName}));
                }
                BindUtils.postNotifyChange((Object)this, (String)"clients");
            }
        });
    }

    private void reloadClients() {
        this.logger.info("Recomputing client list associated to current user");
        this.clients = new TreeMap<Client, Set<Scope>>(Comparator.comparing(Client::getDisplayName));
        this.clients.putAll(this.caService.getUserClientPermissions(this.user.getId()));
    }
}

